/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.jsonserializer.jsonb;

import java.lang.reflect.Type;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import org.coodex.concrete.common.AbstractJsonSerializer;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.config.Config;
import org.coodex.util.Common;
import org.coodex.util.Singleton;

public class JsonbSerializer
extends AbstractJsonSerializer {
    private final Singleton<Jsonb> jsonbSingleton = Singleton.with(() -> {
        String providerName = Config.get((String)"jsonb.provider", (String[])new String[]{ConcreteHelper.getAppSet()});
        return Common.isBlank((String)providerName) ? JsonbBuilder.create() : JsonbBuilder.newBuilder((String)providerName).build();
    });

    private Jsonb getInstance() {
        return (Jsonb)this.jsonbSingleton.get();
    }

    public <T> T parse(String json, Type t) {
        try {
            return (T)(String.class.equals((Object)t) ? Common.cast((Object)json) : this.getInstance().fromJson(json, t));
        }
        catch (Throwable th) {
            throw Common.rte((Throwable)th);
        }
    }

    public String toJson(Object t) {
        return this.getInstance().toJson(t);
    }
}

