/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.dubbo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.coodex.util.Common;
import org.coodex.util.SingletonMap;

public class DubboConfigCaching {
    public static final String DEFAULT_APPLICATION_NAME = "concrete-dubbo-application";
    public static final String DEFAULT_VERSION = "1.0.0";
    private static final SingletonMap<String, ApplicationConfig> applicationConfigs = SingletonMap.builder().function(ApplicationConfig::new).build();
    private static final SingletonMap<String, RegistryConfig> registryConfigs = SingletonMap.builder().function(RegistryConfig::new).build();
    private static final SingletonMap<String, ProtocolConfig> protocolConfigs = SingletonMap.builder().function(name -> {
        int index = name.indexOf(58);
        return index > 0 ? new ProtocolConfig(name.substring(0, index), Integer.parseInt(name.substring(index + 1))) : new ProtocolConfig(name);
    }).build();

    public static String getServiceVersion(String version) {
        return Common.isBlank((String)version) ? DEFAULT_VERSION : version;
    }

    public static ApplicationConfig getApplicationConfig(String name) {
        return (ApplicationConfig)applicationConfigs.get((Object)(Common.isBlank((String)name) ? DEFAULT_APPLICATION_NAME : name));
    }

    public static List<RegistryConfig> getRegistries(Collection<String> registries) {
        return (List)registryConfigs.fill(new ArrayList(), registries);
    }

    public static List<RegistryConfig> getRegistries(String[] registry) {
        return DubboConfigCaching.getRegistries(Arrays.asList(registry));
    }

    public static RegistryConfig getSimpleRegistry() {
        return (RegistryConfig)registryConfigs.get((Object)"localhost:9090");
    }

    public static ProtocolConfig getProtocol(String protocol) {
        return (ProtocolConfig)protocolConfigs.get((Object)protocol);
    }

    public static List<ProtocolConfig> getProtocols(Collection<String> protocols) {
        return (List)protocolConfigs.fill(new ArrayList(), protocols);
    }

    public static List<ProtocolConfig> getProtocols(String[] protocols) {
        return DubboConfigCaching.getProtocols(Arrays.asList(protocols));
    }
}

