/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.client.websocket;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.websocket.ClientEndpoint;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.coodex.concrete.client.Destination;
import org.coodex.concrete.client.impl.OwnRXMessageListener;
import org.coodex.concrete.client.websocket.SetUserAgentConfigurator;
import org.coodex.concrete.client.websocket.WebsocketDestination;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.JSONSerializer;
import org.coodex.concrete.common.JSONSerializerFactory;
import org.coodex.concrete.own.RequestPackage;
import org.coodex.util.Clock;
import org.coodex.util.SingletonMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClientEndpoint(configurator=SetUserAgentConfigurator.class)
public class WSClientHandle {
    private static final Logger log = LoggerFactory.getLogger(WSClientHandle.class);
    private Map<Destination, Session> sessionMap = new HashMap<Destination, Session>();
    private JSONSerializer serializer = JSONSerializerFactory.getInstance();
    private SingletonMap<WebsocketDestination, Object> locks = SingletonMap.builder().function(key -> new Object()).build();

    WSClientHandle() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session getSession(WebsocketDestination destination) throws URISyntaxException, IOException, DeploymentException, InterruptedException {
        Session session = this.sessionMap.get((Object)destination);
        if (session == null || !session.isOpen()) {
            Object lock;
            Object object = lock = this.locks.get((Object)destination);
            synchronized (object) {
                session = this.sessionMap.get((Object)destination);
                if (session == null || !session.isOpen()) {
                    WebSocketContainer container = ContainerProvider.getWebSocketContainer();
                    if (destination.isSsl()) {
                        // empty if block
                    }
                    session = container.connectToServer((Object)this, new URI(destination.getLocation()));
                    session.setMaxIdleTimeout(0L);
                    this.sessionMap.put(destination, session);
                    int maxRetryTimes = 10;
                    int retried = 0;
                    while (!session.isOpen() && retried++ < maxRetryTimes) {
                        Clock.sleep((long)100L);
                    }
                    if (!session.isOpen()) {
                        this.sessionMap.remove((Object)destination);
                        throw new IOException("Cannot open websocket session: " + destination.getLocation());
                    }
                    log.debug("session opened. " + session.getId() + ". " + (Object)((Object)destination));
                }
            }
        }
        return session;
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        OwnRXMessageListener.getInstance().onMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(WebsocketDestination destination, RequestPackage<?> requestPackage) {
        try {
            Session session;
            Session session2 = session = this.getSession(destination);
            synchronized (session2) {
                session.getBasicRemote().sendText(this.serializer.toJson(requestPackage));
            }
        }
        catch (Throwable th) {
            throw ConcreteHelper.getException((Throwable)th);
        }
    }
}

