/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.client.websocket;

import org.coodex.concrete.client.ClientSideContext;
import org.coodex.concrete.client.Destination;
import org.coodex.concrete.client.impl.AbstractOwnRxInvoker;
import org.coodex.concrete.client.websocket.WSClientHandle;
import org.coodex.concrete.client.websocket.WSClientServiceContext;
import org.coodex.concrete.client.websocket.WebsocketDestination;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.concrete.own.RequestPackage;
import org.coodex.concrete.websocket.WebSocketHelper;
import org.coodex.concrete.websocket.WebSocketUnit;
import org.coodex.config.Config;
import org.coodex.logging.Level;
import org.coodex.util.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSInvoker
extends AbstractOwnRxInvoker {
    private static final Logger log = LoggerFactory.getLogger(WSInvoker.class);
    private static Singleton<WSClientHandle> handle = Singleton.with(WSClientHandle::new);
    private final Level level;
    private final WebsocketDestination destination;

    WSInvoker(Destination destination) {
        super(destination);
        this.destination = (WebsocketDestination)destination;
        this.level = Level.parse((String)((String)Config.getValue((String)"client", (Object)"DEBUG", (String[])new String[]{"websocket.logger.level", ConcreteHelper.getAppSet()})));
    }

    protected ClientSideContext getContext() {
        ServiceContext context = ConcreteContext.getServiceContext();
        if (context instanceof WSClientServiceContext) {
            return (WSClientServiceContext)context;
        }
        throw new RuntimeException("context [" + context + "] is NOT WSClientServiceContext");
    }

    protected Logger getLogger() {
        return log;
    }

    protected void send(RequestPackage<?> requestPackage) {
        ((WSClientHandle)handle.get()).send(this.destination, requestPackage);
    }

    public ServiceContext buildContext(DefinitionContext context) {
        return new WSClientServiceContext(this.getDestination(), context);
    }

    protected WebSocketUnit findUnit(DefinitionContext context) {
        return WebSocketHelper.findUnit((DefinitionContext)context);
    }

    protected Level getLoggingLevel() {
        return this.level;
    }
}

