/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.billing;

import org.coodex.billing.Bill;
import org.coodex.billing.Calculator;
import org.coodex.billing.Chargeable;
import org.coodex.util.AcceptableServiceLoader;
import org.coodex.util.Singleton;

public class BillCalculator {
    private static final Singleton<AcceptableServiceLoader<Chargeable, Calculator<Chargeable>>> CALCULATOR_LOADER = new Singleton((Singleton.Builder)new Singleton.Builder<AcceptableServiceLoader<Chargeable, Calculator<Chargeable>>>(){

        public AcceptableServiceLoader<Chargeable, Calculator<Chargeable>> build() {
            return new AcceptableServiceLoader<Chargeable, Calculator<Chargeable>>(){};
        }
    });

    public static <C extends Chargeable> Bill<C> calc(C chargeable) {
        if (chargeable == null) {
            throw new NullPointerException("chargeable is null.");
        }
        Calculator calculator = (Calculator)((AcceptableServiceLoader)CALCULATOR_LOADER.get()).select(chargeable);
        if (calculator == null) {
            throw new RuntimeException("no Calculator instance found for " + chargeable.getClass() + ". " + chargeable.toString());
        }
        return calculator.calc(chargeable);
    }
}

