/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.billing.timebased;

import java.util.Calendar;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.coodex.util.Common;
import org.coodex.util.Section;

public class Period
extends Section<Calendar> {
    public static final Section.Builder<Calendar, Period> BUILDER = new Section.Builder<Calendar, Period>(){

        public Period create(Calendar start, Calendar end) {
            return new Period(start, end);
        }
    };

    private Period(Calendar start, Calendar end) {
        super((Comparable)start, (Comparable)end);
    }

    public static long durationOf(List<Period> periods, TimeUnit unit) {
        long duration = 0L;
        if (periods != null && periods.size() != 0) {
            for (Period period : periods) {
                duration += period.duration(unit);
            }
        }
        return duration;
    }

    protected Calendar cloneObject(Calendar calendar) {
        return (Calendar)calendar.clone();
    }

    public long duration(TimeUnit timeUnit) {
        long duration = ((Calendar)this.getEnd()).getTimeInMillis() - ((Calendar)this.getStart()).getTimeInMillis();
        return timeUnit.convert(duration, TimeUnit.MILLISECONDS);
    }

    public String toString() {
        return "[" + Common.calendarToStr((Calendar)((Calendar)this.getStart())) + " - " + Common.calendarToStr((Calendar)((Calendar)this.getEnd())) + "]";
    }
}

