/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.billing;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.coodex.billing.Chargeable;
import org.coodex.billing.Revision;

public class Bill<C extends Chargeable> {
    private final C chargeable;
    private List<Detail> details = new ArrayList<Detail>();

    public Bill(C chargeable) {
        this.chargeable = chargeable;
    }

    public C getChargeable() {
        return this.chargeable;
    }

    public List<Detail> getDetails() {
        return this.details;
    }

    public void addDetail(Detail detail) {
        this.details.add(detail);
    }

    public void addAllDetails(List<Detail> details) {
        this.details.addAll(details);
    }

    public long getAmount() {
        long amount = 0L;
        for (Detail detail : this.details) {
            amount += detail.getAmount();
        }
        return amount <= 0L ? 0L : amount;
    }

    public Set<Revision> getUsedRevisions() {
        HashSet<Revision> revisionSet = new HashSet<Revision>();
        for (Detail detail : this.details) {
            if (detail.usedRevision() == null) continue;
            revisionSet.add(detail.usedRevision());
        }
        return revisionSet;
    }

    public static class AdjustDetail
    implements Detail {
        private final long amount;
        private final String item;
        private final Revision revision;

        public AdjustDetail(long amount, String item, Revision revision) {
            this.amount = amount;
            this.item = item;
            this.revision = revision;
        }

        @Override
        public long getAmount() {
            return this.amount;
        }

        @Override
        public String item() {
            return this.item;
        }

        @Override
        public Revision usedRevision() {
            return this.revision;
        }
    }

    public static interface Detail {
        public long getAmount();

        public String item();

        public Revision usedRevision();
    }
}

