/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.billing.timebased.reference;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.coodex.billing.timebased.BillingModel;
import org.coodex.billing.timebased.Period;
import org.coodex.billing.timebased.TimeBasedChargeable;
import org.coodex.billing.timebased.reference.AlgorithmFactory;
import org.coodex.billing.timebased.reference.AlgorithmProfile;
import org.coodex.billing.timebased.reference.FragmentProfile;
import org.coodex.billing.timebased.reference.FragmentSlicer;
import org.coodex.billing.timebased.reference.ModelProfile;
import org.coodex.billing.timebased.reference.SlicerFactory;
import org.coodex.billing.timebased.reference.SlicerProfile;
import org.coodex.util.Common;
import org.coodex.util.LazySelectableServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractModelInstance<C extends TimeBasedChargeable>
implements BillingModel.Instance<C> {
    private static final Logger log = LoggerFactory.getLogger(AbstractModelInstance.class);
    private static final Comparator<BillingModel.Fragment> FRAGMENT_COMPARATOR = new Comparator<BillingModel.Fragment>(){

        @Override
        public int compare(BillingModel.Fragment o1, BillingModel.Fragment o2) {
            return ((Calendar)o1.getPeriod().getStart()).compareTo((Calendar)o2.getPeriod().getStart());
        }
    };
    private final LazySelectableServiceLoader<AlgorithmProfile, AlgorithmFactory<C, AlgorithmProfile>> algorithmFactorySelectableServiceLoader = new LazySelectableServiceLoader<AlgorithmProfile, AlgorithmFactory<C, AlgorithmProfile>>(){};
    private final LazySelectableServiceLoader<SlicerProfile, SlicerFactory<C, SlicerProfile>> slicerFactorySelectableServiceLoader = new LazySelectableServiceLoader<SlicerProfile, SlicerFactory<C, SlicerProfile>>(){};
    private final ModelProfile modelProfile;

    public AbstractModelInstance(ModelProfile modelProfile) {
        this.modelProfile = modelProfile;
    }

    private BillingModel.Algorithm<C> getAlgorithm(AlgorithmProfile algorithmProfile) {
        if (algorithmProfile == null) {
            return null;
        }
        AlgorithmFactory factory = (AlgorithmFactory)this.algorithmFactorySelectableServiceLoader.select((Object)algorithmProfile);
        return factory == null ? null : (BillingModel.Algorithm)factory.build(algorithmProfile);
    }

    private FragmentSlicer<C> getSlicer(SlicerProfile slicerProfile) {
        if (slicerProfile == null) {
            return null;
        }
        SlicerFactory slicerFactory = (SlicerFactory)this.slicerFactorySelectableServiceLoader.select((Object)slicerProfile);
        return slicerFactory == null ? null : (FragmentSlicer)slicerFactory.build(slicerProfile);
    }

    protected ModelProfile getModelProfile() {
        return this.modelProfile;
    }

    @Override
    public BillingModel.Algorithm<C> getWholeTimeAlgorithm() {
        return this.getAlgorithm(this.modelProfile.getWholeTimeAlgorithmProfile());
    }

    private void throwExceptionIfNotBlank(List<Period> periods, String label) {
        if (periods.size() > 0) {
            StringBuilder builder = new StringBuilder(label);
            for (Period p : periods) {
                builder.append("\n\tfrom ").append(Common.calendarToStr((Calendar)((Calendar)p.getStart()))).append(" to ").append(Common.calendarToStr((Calendar)((Calendar)p.getEnd())));
            }
            throw new RuntimeException(builder.toString());
        }
    }

    @Override
    public List<BillingModel.Fragment<C>> slice(Period period, C chargeable) {
        ArrayList<BillingModel.Fragment<C>> fragments = new ArrayList<BillingModel.Fragment<C>>();
        for (FragmentProfile profile : this.modelProfile.getFragmentProfiles()) {
            FragmentSlicer<C> slicer = this.getSlicer(profile.getSlicerProfile());
            if (slicer == null) {
                throw new RuntimeException("FragmentSlicer NOT found: " + profile.getSlicerProfile());
            }
            List<Period> periods = slicer.slice(period, chargeable);
            if (periods == null || periods.size() <= 0) continue;
            this.throwExceptionIfNotBlank(Period.sub(periods, Collections.singletonList(period), Period.BUILDER), "out of range:");
            for (Period p : periods) {
                fragments.add(new BillingModel.Fragment<C>(this.getAlgorithm(profile.getAlgorithmProfile()), p));
            }
        }
        if (fragments.size() > 0) {
            Collections.sort(fragments, FRAGMENT_COMPARATOR);
            ArrayList<Period> test = new ArrayList<Period>();
            ArrayList<Period> duplicated = new ArrayList<Period>();
            Period prev = ((BillingModel.Fragment)fragments.get(0)).getPeriod();
            test.add(prev);
            for (int i = 1; i < fragments.size(); ++i) {
                Period current = ((BillingModel.Fragment)fragments.get(i)).getPeriod();
                if (((Calendar)current.getStart()).before(prev.getEnd())) {
                    duplicated.add((Period)Period.BUILDER.create(prev.getEnd(), current.getStart()));
                }
                test.add(current);
            }
            this.throwExceptionIfNotBlank(duplicated, "Duplicated period(s):");
            List missing = Period.sub(Collections.singletonList(period), test, Period.BUILDER);
            if (missing.size() > 0) {
                for (Period p : missing) {
                    log.warn("from {} to {} is missing.", (Object)Common.calendarToStr((Calendar)((Calendar)p.getStart())), (Object)Common.calendarToStr((Calendar)((Calendar)p.getEnd())));
                    fragments.add(new BillingModel.Fragment(null, p));
                }
                Collections.sort(fragments, FRAGMENT_COMPARATOR);
            }
        } else {
            fragments.add(new BillingModel.Fragment(null, period));
            log.warn("slice result is empty.");
        }
        return fragments;
    }
}

