/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.billing.timebased.reference.box;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.coodex.billing.timebased.Period;
import org.coodex.billing.timebased.WholeTimeRevision;
import org.coodex.billing.timebased.reference.box.Utils;

public class DurationRevision
implements WholeTimeRevision {
    private final String name;
    private final TimeUnit unit;
    private final int duration;
    private final boolean fromStart;

    public DurationRevision(String name, int duration) {
        this(name, duration, true);
    }

    public DurationRevision(String name, int duration, boolean fromStart) {
        this(name, TimeUnit.MINUTES, duration, fromStart);
    }

    public DurationRevision(String name, TimeUnit unit, int duration) {
        this(name, unit, duration, true);
    }

    public DurationRevision(String name, TimeUnit unit, int duration, boolean fromStart) {
        this.name = name;
        this.unit = unit;
        this.duration = duration;
        this.fromStart = fromStart;
    }

    private static Period buildPeriod(Calendar c, int duration, TimeUnit timeUnit) {
        Calendar x1 = (Calendar)c.clone();
        Calendar x2 = (Calendar)c.clone();
        x2.add(Utils.timeUnitToCalendarConstant(timeUnit), duration);
        return x1.before(x2) ? (Period)Period.BUILDER.create((Comparable)x1, (Comparable)x2) : (Period)Period.BUILDER.create((Comparable)x2, (Comparable)x1);
    }

    @Override
    public List<Period> revised(List<Period> periods) {
        ArrayList<Period> result = new ArrayList<Period>();
        int index = this.fromStart ? 0 : periods.size() - 1;
        int remainder = this.duration;
        while (this.fromStart ? index < periods.size() : index >= 0) {
            Period period = periods.get(index);
            if (period.duration(this.unit) <= (long)remainder) {
                result.add(period);
                remainder = (int)((long)remainder - period.duration(this.unit));
            } else {
                result.add(this.fromStart ? DurationRevision.buildPeriod((Calendar)period.getStart(), remainder, this.unit) : DurationRevision.buildPeriod((Calendar)period.getEnd(), -remainder, this.unit));
                remainder = 0;
            }
            if (remainder == 0) break;
            if (this.fromStart) {
                ++index;
                continue;
            }
            --index;
        }
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

