/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.billing.timebased.reference.box;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.coodex.billing.timebased.Period;
import org.coodex.billing.timebased.TimeBasedChargeable;
import org.coodex.billing.timebased.reference.FragmentSlicer;
import org.coodex.billing.timebased.reference.SlicerFactory;
import org.coodex.billing.timebased.reference.box.FragmentSlicerProfile;
import org.coodex.billing.timebased.reference.box.Utils;
import org.coodex.util.Section;

public class FragmentSlicerFactory<C extends TimeBasedChargeable>
implements SlicerFactory<C, FragmentSlicerProfile> {
    public FragmentSlicer<C> build(FragmentSlicerProfile fragmentSlicerProfile) {
        return new FragmentSlicerImpl(fragmentSlicerProfile);
    }

    public boolean accept(FragmentSlicerProfile param) {
        return param != null && FragmentSlicerProfile.class.equals(param.getClass());
    }

    public static class FragmentSlicerImpl<C extends TimeBasedChargeable>
    implements FragmentSlicer<C> {
        private final FragmentSlicerProfile fragmentProfile;

        public FragmentSlicerImpl(FragmentSlicerProfile fragmentProfile) {
            this.fragmentProfile = fragmentProfile;
        }

        @Override
        public List<Period> slice(Period period, C chargeable) {
            try {
                ArrayList<Period> result = new ArrayList<Period>();
                Calendar fStart = Utils.getCal(this.fragmentProfile.getStartTime());
                Calendar fEnd = Utils.getCal(this.fragmentProfile.getEndTime());
                Utils.setDate(fStart, (Calendar)period.getStart());
                Utils.setDate(fEnd, (Calendar)period.getStart());
                if (fStart.after(fEnd)) {
                    fStart.add(5, -1);
                }
                List<Period> wholeTime = Collections.singletonList(period);
                while (fStart.before(period.getEnd())) {
                    List intersection = Section.intersect(wholeTime, Collections.singletonList(Period.BUILDER.create((Comparable)fStart, (Comparable)fEnd)), Period.BUILDER);
                    if (intersection.size() > 0) {
                        result.addAll(intersection);
                    }
                    fStart.add(5, 1);
                    fEnd.add(5, 1);
                }
                return result;
            }
            catch (ParseException e) {
                throw new RuntimeException(e.getLocalizedMessage(), e);
            }
        }
    }
}

