/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.billing.timebased.reference.box;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.coodex.billing.timebased.Period;
import org.coodex.billing.timebased.TimeBasedChargeable;
import org.coodex.billing.timebased.reference.FragmentSlicer;
import org.coodex.billing.timebased.reference.SlicerFactory;
import org.coodex.billing.timebased.reference.box.FixedHoursSlicerProfile;

public class FixedHoursSlicerFactory<C extends TimeBasedChargeable>
implements SlicerFactory<C, FixedHoursSlicerProfile> {
    public FragmentSlicer<C> build(FixedHoursSlicerProfile fixedHoursSlicerProfile) {
        return new FixedHoursSlicer(fixedHoursSlicerProfile.getFixedHours());
    }

    public boolean accept(FixedHoursSlicerProfile param) {
        return param != null && FixedHoursSlicerProfile.class.equals(param.getClass());
    }

    public static class FixedHoursSlicer<C extends TimeBasedChargeable>
    implements FragmentSlicer<C> {
        private final int fixedHours;

        FixedHoursSlicer(int fixedHours) {
            this.fixedHours = fixedHours;
        }

        @Override
        public List<Period> slice(Period period, C chargeable) {
            Calendar start = (Calendar)((Calendar)period.getStart()).clone();
            ArrayList<Period> result = new ArrayList<Period>();
            while (start.before(period.getEnd())) {
                Calendar next = (Calendar)start.clone();
                next.add(10, this.fixedHours);
                Period p = (Period)Period.BUILDER.create((Comparable)start, (Comparable)(next.before(period.getEnd()) ? next : (Calendar)period.getEnd()));
                if (p.duration(TimeUnit.SECONDS) > 0L) {
                    result.add(p);
                }
                start = next;
            }
            return result;
        }
    }
}

