/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.billing.timebased.reference;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.coodex.billing.Bill;
import org.coodex.billing.timebased.BillingModel;
import org.coodex.billing.timebased.Period;
import org.coodex.billing.timebased.TimeBasedChargeable;

public abstract class AbstractAlgorithm<C extends TimeBasedChargeable>
implements BillingModel.Algorithm<C> {
    @Override
    public List<Bill.Detail> calc(List<Period> periodList, C chargeable) {
        ArrayList<Bill.Detail> details = new ArrayList<Bill.Detail>();
        if (this.isDiscontinuityAllowed() && periodList.size() > 1) {
            details.add(this.calc((Period)Period.BUILDER.create(periodList.get(0).getStart(), periodList.get(periodList.size() - 1).getEnd()), Period.durationOf(periodList, this.getTimeUnit()), chargeable));
        } else {
            for (Period period : periodList) {
                details.add(this.calc(period, period.duration(this.getTimeUnit()), chargeable));
            }
        }
        return details;
    }

    protected boolean isDiscontinuityAllowed() {
        return true;
    }

    protected TimeUnit getTimeUnit() {
        return TimeUnit.MINUTES;
    }

    protected abstract Bill.Detail calc(Period var1, long var2, C var4);
}

