/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.billing.timebased;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.coodex.billing.Adjustment;
import org.coodex.billing.Bill;
import org.coodex.billing.Calculator;
import org.coodex.billing.PaidAdjustment;
import org.coodex.billing.Revision;
import org.coodex.billing.timebased.BillingModel;
import org.coodex.billing.timebased.BillingRule;
import org.coodex.billing.timebased.BillingRuleRepository;
import org.coodex.billing.timebased.FragmentRevision;
import org.coodex.billing.timebased.OnlyOnce;
import org.coodex.billing.timebased.Period;
import org.coodex.billing.timebased.RevisionToDetail;
import org.coodex.billing.timebased.TimeBasedBill;
import org.coodex.billing.timebased.TimeBasedChargeable;
import org.coodex.billing.timebased.TimeBasedDetail;
import org.coodex.billing.timebased.TimeBasedRevision;
import org.coodex.billing.timebased.WholeTimeRevision;
import org.coodex.exception.NoneInstanceException;
import org.coodex.exception.NoneSupportedException;
import org.coodex.util.Common;
import org.coodex.util.LazySelectableServiceLoader;
import org.coodex.util.Section;
import org.coodex.util.SelectableServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTimeBasedCalculator<C extends TimeBasedChargeable>
implements Calculator<C> {
    private static final Logger log = LoggerFactory.getLogger(AbstractTimeBasedCalculator.class);
    private static final RevisionToDetail<Revision> DEFAULT_REVISION = new RevisionToDetail<Revision>(){

        @Override
        public Bill.Detail toDetail(Revision revision, Period period, long amount) {
            if (revision instanceof TimeBasedRevision) {
                return new TimeBasedDetailImpl(period, amount, revision, revision.getName());
            }
            if (revision instanceof Adjustment) {
                return amount == 0L ? null : new Bill.AdjustDetail(amount, revision.getName(), revision);
            }
            throw new NoneSupportedException("do not support this revision: " + (revision == null ? null : revision.getClass()));
        }

        public boolean accept(Revision param) {
            return true;
        }
    };
    private static final SelectableServiceLoader<Revision, RevisionToDetail<Revision>> detailCreators = new LazySelectableServiceLoader<Revision, RevisionToDetail<Revision>>(DEFAULT_REVISION){};
    private final SelectableServiceLoader<String, BillingModel<C>> billingModels = new LazySelectableServiceLoader<String, BillingModel<C>>(){};
    private final SelectableServiceLoader<C, BillingRuleRepository<C>> ruleRepos = new LazySelectableServiceLoader<C, BillingRuleRepository<C>>(new BillingRuleRepository<C>(){

        @Override
        public Collection<BillingRule> getRulesBy(C chargeable) {
            return Collections.emptyList();
        }

        public boolean accept(C param) {
            return true;
        }
    }){};

    protected abstract TimeUnit getTimeUnit();

    @Override
    public Bill<C> calc(C chargeable) {
        BillingRuleRepository ruleRepository = (BillingRuleRepository)this.ruleRepos.select(chargeable);
        if (ruleRepository == null) {
            return this.calcWithARule(chargeable);
        }
        Object[] rules = ruleRepository.getRulesBy(chargeable).toArray(new BillingRule[0]);
        if (rules.length > 1) {
            Arrays.sort(rules);
            ArrayList<C> consumptions = new ArrayList<C>();
            ArrayList<Adjustment> adjustments = new ArrayList<Adjustment>();
            ArrayList<Revision> revisions = new ArrayList<Revision>();
            ArrayList<Revision> onlyOnce = new ArrayList<Revision>();
            for (Revision revision : chargeable.getRevisions()) {
                if (revision instanceof Adjustment && revision instanceof PaidAdjustment) {
                    adjustments.add((Adjustment)Common.cast((Object)revision));
                    continue;
                }
                if (!(revision instanceof OnlyOnce)) {
                    revisions.add(revision);
                }
                onlyOnce.add(revision);
            }
            boolean onlyOnceAdded = false;
            Calendar end = (Calendar)chargeable.getPeriod().getEnd();
            for (int x = rules.length - 1; x >= 0; --x) {
                Object rule = rules[x];
                if (!((Calendar)chargeable.getPeriod().getEnd()).after(((BillingRule)rule).getStart())) continue;
                Calendar start = (Calendar)Common.max((Comparable)((Calendar)chargeable.getPeriod().getStart()), (Comparable)((BillingRule)rule).getStart(), (Comparable[])new Calendar[0]);
                if (((Calendar)chargeable.getPeriod().getStart()).after(end)) break;
                C consumption = this.copyChargeable(chargeable, onlyOnceAdded ? revisions : onlyOnce);
                consumption.setModel(((BillingRule)rule).getModel());
                consumption.setModelParam(((BillingRule)rule).getModelParam());
                consumption.setPeriod((Period)Period.BUILDER.create((Comparable)((Calendar)start.clone()), (Comparable)((Calendar)end.clone())));
                consumptions.add(consumption);
                end = ((BillingRule)rule).getStart();
                onlyOnceAdded = true;
            }
            switch (consumptions.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    return this.adjustBill(this.calcWithARule((TimeBasedChargeable)consumptions.get(0)), adjustments);
                }
                default: {
                    Bill<C> bill = new Bill<C>(chargeable);
                    for (int x = consumptions.size() - 1; x >= 0; --x) {
                        Bill<TimeBasedChargeable> consumptionBill = this.calcWithARule((TimeBasedChargeable)consumptions.get(x));
                        bill.addAllDetails(consumptionBill.getDetails());
                    }
                    return this.adjustBill(bill, adjustments);
                }
            }
        } else if (rules.length == 1) {
            chargeable.setModel(((BillingRule)rules[0]).getModel());
            chargeable.setModelParam(((BillingRule)rules[0]).getModelParam());
        }
        return this.calcWithARule(chargeable);
    }

    protected abstract C copyChargeable(C var1, List<Revision> var2);

    private Bill<C> calcWithARule(C chargeable) {
        BillingModel billingModel = (BillingModel)this.billingModels.select((Object)chargeable.getModel());
        if (billingModel == null) {
            throw new NoneInstanceException("NONE BillingModel Found for " + chargeable.getModel());
        }
        BillCalc billCalc = new BillCalc((TimeBasedChargeable)chargeable, billingModel, null);
        Bill bill = billCalc.getBill(this.getTimeUnit());
        return this.adjustBill(bill, billCalc.adjustments);
    }

    protected Bill<C> adjustBill(Bill<C> bill, List<? extends Adjustment<C>> adjustments) {
        if (Common.isEmpty(adjustments)) {
            return bill;
        }
        for (Adjustment<C> adjustment : adjustments) {
            long amount = adjustment.adjust(bill);
            Bill.Detail detail = ((RevisionToDetail)detailCreators.select(adjustment)).toDetail(adjustment, null, amount);
            if (detail == null) continue;
            bill.addDetail(detail);
        }
        return bill;
    }

    private static class BillCalc<C extends TimeBasedChargeable> {
        private final C chargeable;
        private final BillingModel<C> billingModel;
        private final List<WholeTimeRevision> wholeTimeRevisions = new ArrayList<WholeTimeRevision>();
        private final List<FragmentRevision> fragmentRevisions = new ArrayList<FragmentRevision>();
        private final List<Adjustment<C>> adjustments = new ArrayList<Adjustment<C>>();

        private BillCalc(C chargeable, BillingModel<C> billingModel) {
            this.chargeable = chargeable;
            this.billingModel = billingModel;
            this.initRevisions(chargeable);
        }

        Bill<C> getBill(TimeUnit unit) {
            List<Bill.Detail> details;
            TimeBasedBill<C> bill = new TimeBasedBill<C>(this.chargeable);
            if (this.chargeable.getPeriod().duration(unit) == 0L) {
                return bill;
            }
            List<Period> chargePeriods = new ArrayList<Period>();
            chargePeriods.add(this.chargeable.getPeriod());
            chargePeriods = this.beforeSlice(unit, bill, chargePeriods);
            if (Period.durationOf(chargePeriods, unit) == 0L) {
                return bill;
            }
            chargePeriods = Section.merge(chargePeriods, Period.BUILDER);
            BillingModel.Instance<C> instance = this.billingModel.create(this.chargeable);
            Period chargePeriod = (Period)Period.BUILDER.create((Comparable)((Calendar)chargePeriods.get(0).getStart()), (Comparable)((Calendar)chargePeriods.get(chargePeriods.size() - 1).getEnd()));
            boolean slice = true;
            if (instance.getWholeTimeAlgorithm() != null && (details = instance.getWholeTimeAlgorithm().calc(chargePeriods, this.chargeable)) != null && details.size() > 0) {
                bill.addAllDetails(details);
                slice = false;
            }
            if (slice) {
                List<BillingModel.Fragment<C>> fragments = instance.slice(chargePeriod, this.chargeable);
                for (BillingModel.Fragment<C> fragment : fragments) {
                    if (fragment.getAlgorithm() != null) {
                        List<Period> chargeFragment = Section.intersect(Collections.singletonList(fragment.getPeriod()), chargePeriods, Period.BUILDER);
                        for (FragmentRevision fragmentRevision : this.fragmentRevisions) {
                            if (!fragmentRevision.accept(chargeFragment) || Period.durationOf(chargeFragment = this.revised(bill, chargeFragment, fragmentRevision), unit) != 0L) continue;
                            return bill;
                        }
                        List<Bill.Detail> details2 = fragment.getAlgorithm().calc(chargeFragment, this.chargeable);
                        if (details2 == null || details2.size() <= 0) continue;
                        bill.addAllDetails(details2);
                        continue;
                    }
                    bill.addDetail(new TimeBasedDetailImpl(fragment.getPeriod(), 0L, null, "no algorithm found."));
                }
            }
            return bill;
        }

        private List<Period> beforeSlice(TimeUnit unit, TimeBasedBill<C> bill, List<Period> chargePeriods) {
            for (WholeTimeRevision revision : this.wholeTimeRevisions) {
                if (Period.durationOf(chargePeriods = this.revised(bill, chargePeriods, revision), unit) != 0L) continue;
                return chargePeriods;
            }
            return chargePeriods;
        }

        private List<Period> revised(TimeBasedBill<C> bill, List<Period> chargePeriods, TimeBasedRevision revision) {
            List<Period> revised = revision.revised(chargePeriods);
            if (revised != null && revised.size() > 0) {
                for (Period period : revised) {
                    bill.addDetail(((RevisionToDetail)detailCreators.select((Object)revision)).toDetail(revision, period, 0L));
                }
                chargePeriods = Section.sub(chargePeriods, revised, Period.BUILDER);
            }
            return chargePeriods;
        }

        private void initRevisions(C chargeable) {
            if (chargeable.getRevisions() != null && chargeable.getRevisions().size() > 0) {
                for (Revision revision : chargeable.getRevisions()) {
                    if (revision == null) continue;
                    if (revision instanceof WholeTimeRevision) {
                        this.wholeTimeRevisions.add((WholeTimeRevision)revision);
                        continue;
                    }
                    if (revision instanceof FragmentRevision) {
                        this.fragmentRevisions.add((FragmentRevision)revision);
                        continue;
                    }
                    if (revision instanceof Adjustment) {
                        this.adjustments.add((Adjustment)Common.cast((Object)revision));
                        continue;
                    }
                    log.warn("unsupported Revision: {}, {}", (Object)revision.getClass().getName(), (Object)revision.getName());
                }
            }
        }

        /* synthetic */ BillCalc(TimeBasedChargeable x0, BillingModel x1, 1 x2) {
            this(x0, x1);
        }
    }

    public static class TimeBasedDetailImpl
    implements TimeBasedDetail {
        private final Period period;
        private final long amount;
        private final Revision revision;
        private final String item;

        public TimeBasedDetailImpl(Period period, long amount, String item) {
            this(period, amount, null, item);
        }

        public TimeBasedDetailImpl(Period period, long amount, Revision revision, String item) {
            this.period = period;
            this.amount = amount;
            this.revision = revision;
            this.item = item;
        }

        @Override
        public Period getPeriod() {
            return this.period;
        }

        @Override
        public long getAmount() {
            return this.amount;
        }

        @Override
        public String item() {
            return this.item;
        }

        @Override
        public Revision usedRevision() {
            return this.revision;
        }
    }
}

