/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.billing.timebased.reference.box;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.coodex.billing.timebased.Period;
import org.coodex.billing.timebased.TimeBasedChargeable;
import org.coodex.billing.timebased.reference.FragmentSlicer;
import org.coodex.billing.timebased.reference.SlicerFactory;
import org.coodex.billing.timebased.reference.box.FixedDateSlicerProfile;
import org.coodex.billing.timebased.reference.box.Utils;
import org.coodex.exception.ParseRuntimeException;

public class FixedDateSlicerFactory<C extends TimeBasedChargeable>
implements SlicerFactory<C, FixedDateSlicerProfile> {
    public FragmentSlicer<C> build(FixedDateSlicerProfile fixedDateSlicerProfile) {
        return new FixedDateSlicer(fixedDateSlicerProfile);
    }

    public boolean accept(FixedDateSlicerProfile param) {
        return param != null && FixedDateSlicerProfile.class.equals(param.getClass());
    }

    public static class FixedDateSlicer<C extends TimeBasedChargeable>
    implements FragmentSlicer<C> {
        private final FixedDateSlicerProfile profile;

        public FixedDateSlicer(FixedDateSlicerProfile profile) {
            this.profile = profile;
        }

        @Override
        public List<Period> slice(Period period, C chargeable) {
            try {
                Calendar start = Utils.getCal(this.profile.getStartTime());
                Utils.setDate(start, (Calendar)period.getStart());
                while (start.after(period.getStart())) {
                    start.add(5, -1);
                }
                ArrayList<Period> periods = new ArrayList<Period>();
                while (start.before(period.getEnd())) {
                    Calendar next = (Calendar)start.clone();
                    next.add(5, 1);
                    Period p = (Period)Period.BUILDER.create((Comparable)(start.before(period.getStart()) ? (Calendar)period.getStart() : start), (Comparable)(next.before(period.getEnd()) ? next : (Calendar)period.getEnd()));
                    if (p.duration(TimeUnit.SECONDS) > 0L) {
                        periods.add(p);
                    }
                    start = next;
                }
                return periods;
            }
            catch (ParseException e) {
                throw new ParseRuntimeException("cannot parse " + this.profile.getStartTime(), e);
            }
        }
    }
}

