/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.billing.box;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.coodex.billing.Adjustment;
import org.coodex.billing.Bill;
import org.coodex.billing.Chargeable;

public class ConsumerGoods
implements Adjustment<Chargeable> {
    private final int price;
    private final float quantity;
    private final String name;

    public ConsumerGoods(int price, float quantity, String name) {
        this.price = price;
        this.quantity = quantity;
        this.name = name;
    }

    @Override
    public long adjust(Bill<Chargeable> bill) {
        return BigDecimal.valueOf(this.price).multiply(BigDecimal.valueOf(this.quantity)).setScale(0, RoundingMode.HALF_UP).longValue();
    }

    @Override
    public String getName() {
        return this.name + "[" + this.price + " x " + this.quantity + "]";
    }

    public int getPrice() {
        return this.price;
    }

    public float getQuantity() {
        return this.quantity;
    }
}

