/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.billing;

import org.coodex.billing.Bill;
import org.coodex.billing.Calculator;
import org.coodex.billing.Chargeable;
import org.coodex.exception.NoneInstanceException;
import org.coodex.util.Common;
import org.coodex.util.LazySelectableServiceLoader;
import org.coodex.util.SelectableServiceLoader;

public class BillCalculator {
    private static final SelectableServiceLoader<Chargeable, Calculator<Chargeable>> CALCULATOR_LOADER = new LazySelectableServiceLoader<Chargeable, Calculator<Chargeable>>(){};

    private BillCalculator() {
    }

    public static <C extends Chargeable> Bill<C> calc(C chargeable) {
        if (chargeable == null) {
            throw new NullPointerException("chargeable is null.");
        }
        Calculator calculator = (Calculator)CALCULATOR_LOADER.select(chargeable);
        if (calculator == null) {
            throw new NoneInstanceException("no Calculator instance found for " + chargeable.getClass() + ". " + chargeable.toString());
        }
        return (Bill)Common.cast(calculator.calc(chargeable));
    }
}

