/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.billing.timebased;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import org.coodex.billing.Bill;
import org.coodex.billing.timebased.TimeBasedChargeable;
import org.coodex.billing.timebased.TimeBasedDetail;

public class TimeBasedBill<C extends TimeBasedChargeable>
extends Bill<C> {
    private static final Comparator<Bill.Detail> DETAIL_COMPARATOR = (o1, o2) -> {
        TimeBasedDetail detail2;
        TimeBasedDetail detail1 = o1 instanceof TimeBasedDetail ? (TimeBasedDetail)o1 : null;
        TimeBasedDetail timeBasedDetail = detail2 = o2 instanceof TimeBasedDetail ? (TimeBasedDetail)o2 : null;
        if (detail1 != null && detail2 != null) {
            return ((Calendar)detail1.getPeriod().getStart()).compareTo((Calendar)detail2.getPeriod().getStart());
        }
        if (detail1 != null) {
            return -1;
        }
        if (detail2 != null) {
            return 1;
        }
        return 0;
    };

    public TimeBasedBill(C chargeable) {
        super(chargeable);
    }

    @Override
    public List<Bill.Detail> getDetails() {
        ArrayList<Bill.Detail> details = new ArrayList<Bill.Detail>(super.getDetails());
        details.sort(DETAIL_COMPARATOR);
        return details;
    }
}

