/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.jaxrs.logging;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.coodex.logging.Level;
import org.slf4j.Logger;

public class AbstractLogger
implements WriterInterceptor {
    protected static final String REQUEST_PREFIX = "> ";
    protected static final String RESPONSE_PREFIX = "< ";
    protected static final String ENTITY_LOGGER_PROPERTY = AbstractLogger.class.getName() + ".entityLogger";
    protected static final String LOGGING_ID_PROPERTY = AbstractLogger.class.getName() + ".id";
    protected static final int MAX_ENTITY_SIZE = 8192;
    private static final String NOTIFICATION_PREFIX = "* ";
    private static final MediaType TEXT_MEDIA_TYPE = new MediaType("text", "*");
    private static final Set<MediaType> READABLE_APP_MEDIA_TYPES = new HashSet<MediaType>();
    private static final Comparator<Map.Entry<String, List<String>>> COMPARATOR;
    protected final AtomicLong _id = new AtomicLong(0L);
    private final Logger log;
    private final Level level;

    public AbstractLogger(Logger log, Level level) {
        this.log = log;
        this.level = level;
    }

    protected static boolean isReadable(MediaType mediaType) {
        if (mediaType != null) {
            for (MediaType readableMediaType : READABLE_APP_MEDIA_TYPES) {
                if (!readableMediaType.isCompatible(mediaType)) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean printEntity(MediaType mediaType) {
        return AbstractLogger.isReadable(mediaType);
    }

    protected static Charset getCharset(MediaType m) {
        String name = m == null ? null : (String)m.getParameters().get("charset");
        return name == null ? StandardCharsets.UTF_8 : Charset.forName(name);
    }

    protected boolean isEnabled() {
        return this.level.isEnabled(this.log);
    }

    protected void log(StringBuilder b) {
        if (this.level.isEnabled(this.log)) {
            this.level.log(this.log, b.toString());
        }
    }

    private StringBuilder prefixId(StringBuilder b, long id) {
        b.append(id).append(" ");
        return b;
    }

    protected void printRequestLine(StringBuilder b, String note, long id, String method, URI uri) {
        this.prefixId(b, id).append(NOTIFICATION_PREFIX).append(note).append(" on thread ").append(Thread.currentThread().getName()).append("\n");
        this.prefixId(b, id).append(REQUEST_PREFIX).append(method).append(" ").append(uri.toASCIIString()).append("\n");
    }

    protected void printResponseLine(StringBuilder b, String note, long id, int status) {
        this.prefixId(b, id).append(NOTIFICATION_PREFIX).append(note).append(" on thread ").append(Thread.currentThread().getName()).append("\n");
        this.prefixId(b, id).append(RESPONSE_PREFIX).append(status).append("\n");
    }

    protected void printPrefixedHeaders(StringBuilder b, long id, String prefix, MultivaluedMap<String, String> headers) {
        for (Map.Entry<String, List<String>> headerEntry : this.getSortedHeaders(headers.entrySet())) {
            List<String> val = headerEntry.getValue();
            String header = headerEntry.getKey();
            if (val.size() == 1) {
                String value = val.get(0);
                try {
                    String decoded = URLDecoder.decode(value, "UTF-8");
                    if (!value.equals(decoded)) {
                        value = value + "[decoded value:" + decoded + "]";
                    }
                }
                catch (UnsupportedEncodingException decoded) {
                    // empty catch block
                }
                this.prefixId(b, id).append(prefix).append(header).append(": ").append(value).append("\n");
                continue;
            }
            StringBuilder sb = new StringBuilder();
            boolean add = false;
            for (String s : val) {
                if (add) {
                    sb.append(',');
                }
                add = true;
                String value = s;
                try {
                    String decoded = URLDecoder.decode(value, "UTF-8");
                    if (!value.equals(decoded)) {
                        value = value + "[decoded value:" + decoded + "]";
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                sb.append(value);
            }
            this.prefixId(b, id).append(prefix).append(header).append(": ").append(sb.toString()).append("\n");
        }
    }

    Set<Map.Entry<String, List<String>>> getSortedHeaders(Set<Map.Entry<String, List<String>>> headers) {
        TreeSet<Map.Entry<String, List<String>>> sortedHeaders = new TreeSet<Map.Entry<String, List<String>>>(COMPARATOR);
        sortedHeaders.addAll(headers);
        return sortedHeaders;
    }

    protected InputStream logInboundEntity(StringBuilder b, InputStream stream, Charset charset) throws IOException {
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        stream.mark(8193);
        byte[] entity = new byte[8193];
        int entitySize = stream.read(entity);
        b.append(new String(entity, 0, Math.min(entitySize, 8192), charset));
        if (entitySize > 8192) {
            b.append("...more...");
        }
        b.append('\n');
        stream.reset();
        return stream;
    }

    public void aroundWriteTo(WriterInterceptorContext writerInterceptorContext) throws IOException, WebApplicationException {
        LoggingStream stream = (LoggingStream)writerInterceptorContext.getProperty(ENTITY_LOGGER_PROPERTY);
        writerInterceptorContext.proceed();
        if (AbstractLogger.printEntity(writerInterceptorContext.getMediaType()) && stream != null) {
            this.log(stream.getStringBuilder(AbstractLogger.getCharset(writerInterceptorContext.getMediaType())));
        }
    }

    static {
        READABLE_APP_MEDIA_TYPES.add(TEXT_MEDIA_TYPE);
        READABLE_APP_MEDIA_TYPES.add(MediaType.APPLICATION_ATOM_XML_TYPE);
        READABLE_APP_MEDIA_TYPES.add(MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        READABLE_APP_MEDIA_TYPES.add(MediaType.APPLICATION_JSON_TYPE);
        READABLE_APP_MEDIA_TYPES.add(MediaType.APPLICATION_SVG_XML_TYPE);
        READABLE_APP_MEDIA_TYPES.add(MediaType.APPLICATION_XHTML_XML_TYPE);
        READABLE_APP_MEDIA_TYPES.add(MediaType.APPLICATION_XML_TYPE);
        COMPARATOR = (o1, o2) -> ((String)o1.getKey()).compareToIgnoreCase((String)o2.getKey());
    }

    protected static class LoggingStream
    extends FilterOutputStream {
        private final StringBuilder b;
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

        public LoggingStream(StringBuilder b, OutputStream inner) {
            super(inner);
            this.b = b;
        }

        public StringBuilder getStringBuilder(Charset charset) {
            byte[] entity = this.baos.toByteArray();
            this.b.append(new String(entity, 0, Math.min(entity.length, 8192), charset));
            if (entity.length > 8192) {
                this.b.append("...more...");
            }
            this.b.append('\n');
            return this.b;
        }

        @Override
        public void write(int i) throws IOException {
            if (this.baos.size() <= 8192) {
                this.baos.write(i);
            }
            this.out.write(i);
        }
    }
}

