/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.jaxrs.logging;

import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.OutputStream;
import org.coodex.jaxrs.logging.AbstractLogger;
import org.coodex.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConstrainedTo(value=RuntimeType.SERVER)
@PreMatching
public class ServerLogger
extends AbstractLogger
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Logger logger = LoggerFactory.getLogger(ServerLogger.class);

    public ServerLogger() {
        this(null, null);
    }

    public ServerLogger(Logger log, Level level) {
        super(log == null ? logger : log, level == null ? Level.INFO : level);
    }

    public void filter(ContainerRequestContext context) throws IOException {
        if (!this.isEnabled()) {
            return;
        }
        long id = this._id.incrementAndGet();
        context.setProperty(LOGGING_ID_PROPERTY, (Object)id);
        StringBuilder b = new StringBuilder();
        this.printRequestLine(b, "Server has received a request", id, context.getMethod(), context.getUriInfo().getRequestUri());
        this.printPrefixedHeaders(b, id, "> ", (MultivaluedMap<String, String>)context.getHeaders());
        if (context.hasEntity() && ServerLogger.printEntity(context.getMediaType())) {
            context.setEntityStream(this.logInboundEntity(b, context.getEntityStream(), ServerLogger.getCharset(context.getMediaType())));
        }
        this.log(b);
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (!this.isEnabled()) {
            return;
        }
        Object requestId = requestContext.getProperty(LOGGING_ID_PROPERTY);
        long id = requestId != null ? ((Long)requestId).longValue() : this._id.incrementAndGet();
        StringBuilder b = new StringBuilder();
        this.printResponseLine(b, "Server responded with a response", id, responseContext.getStatus());
        this.printPrefixedHeaders(b, id, "< ", (MultivaluedMap<String, String>)responseContext.getStringHeaders());
        if (responseContext.hasEntity() && ServerLogger.printEntity(responseContext.getMediaType())) {
            AbstractLogger.LoggingStream stream = new AbstractLogger.LoggingStream(b, responseContext.getEntityStream());
            responseContext.setEntityStream((OutputStream)stream);
            requestContext.setProperty(ENTITY_LOGGER_PROPERTY, (Object)stream);
        } else {
            this.log(b);
        }
    }
}

