/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.jaxrs.logging;

import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.OutputStream;
import org.coodex.jaxrs.logging.AbstractLogger;
import org.coodex.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConstrainedTo(value=RuntimeType.CLIENT)
@PreMatching
public class ClientLogger
extends AbstractLogger
implements ClientRequestFilter,
ClientResponseFilter {
    private static final Logger logger = LoggerFactory.getLogger(ClientLogger.class);

    public ClientLogger() {
        this(null, null);
    }

    public ClientLogger(Logger log, Level level) {
        super(log == null ? logger : log, level == null ? Level.INFO : level);
    }

    public void filter(ClientRequestContext context) throws IOException {
        if (!this.isEnabled()) {
            return;
        }
        long id = this._id.incrementAndGet();
        context.setProperty(LOGGING_ID_PROPERTY, (Object)id);
        StringBuilder b = new StringBuilder();
        this.printRequestLine(b, "Sending client request", id, context.getMethod(), context.getUri());
        this.printPrefixedHeaders(b, id, "> ", (MultivaluedMap<String, String>)context.getStringHeaders());
        if (context.hasEntity() && ClientLogger.printEntity(context.getMediaType())) {
            AbstractLogger.LoggingStream stream = new AbstractLogger.LoggingStream(b, context.getEntityStream());
            context.setEntityStream((OutputStream)stream);
            context.setProperty(ENTITY_LOGGER_PROPERTY, (Object)stream);
        } else {
            this.log(b);
        }
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        if (!this.isEnabled()) {
            return;
        }
        Object requestId = requestContext.getProperty(LOGGING_ID_PROPERTY);
        long id = requestId != null ? ((Long)requestId).longValue() : this._id.incrementAndGet();
        StringBuilder b = new StringBuilder();
        this.printResponseLine(b, "Client response received", id, responseContext.getStatus());
        this.printPrefixedHeaders(b, id, "< ", (MultivaluedMap<String, String>)responseContext.getHeaders());
        if (responseContext.hasEntity() && ClientLogger.printEntity(responseContext.getMediaType())) {
            responseContext.setEntityStream(this.logInboundEntity(b, responseContext.getEntityStream(), ClientLogger.getCharset(responseContext.getMediaType())));
        }
        this.log(b);
    }
}

