/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util.json;

import java.lang.reflect.Type;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import org.coodex.config.Config;
import org.coodex.util.AbstractJSONSerializer;
import org.coodex.util.Common;
import org.coodex.util.JSONSerializer;
import org.coodex.util.Singleton;

public class JsonbSerializer
extends AbstractJSONSerializer
implements JSONSerializer {
    private static final Singleton<Jsonb> jsonbSingleton = Singleton.with(() -> {
        String providerName = Config.get((String)"jsonb.v1.provider", (String[])new String[0]);
        return Common.isBlank((String)providerName) ? JsonbBuilder.create() : JsonbBuilder.newBuilder((String)providerName).build();
    });

    public static Jsonb getInstance() {
        return (Jsonb)jsonbSingleton.get();
    }

    public <T> T parse(String json, Type t) {
        if (Common.isBlank((String)json)) {
            return null;
        }
        try {
            return (T)JsonbSerializer.getInstance().fromJson(json, t);
        }
        catch (Throwable th) {
            throw Common.rte((Throwable)th);
        }
    }

    public String toJson(Object t, boolean writeNullValue) {
        return JsonbSerializer.getInstance().toJson(t);
    }
}

