/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.jts;

import java.util.Objects;
import org.coodex.jts.GeometryConvertService;
import org.coodex.util.Common;
import org.coodex.util.LazySelectableServiceLoader;
import org.coodex.util.SelectableServiceLoader;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class JTSUtil {
    public static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();
    private static final SelectableServiceLoader<Geometry, GeometryConvertService<Geometry>> CONVERT_SERVICE_LOADER = new LazySelectableServiceLoader<Geometry, GeometryConvertService<Geometry>>(){};
    private static final double EARTH_RADIUS = 6378137.0;

    public static double[] lngLat2Mercator(double[] lngLat) {
        return JTSUtil.lngLat2Mercator(lngLat[0], lngLat[1]);
    }

    public static double[] lngLat2Mercator(double lng, double lat) {
        double x = lng * Math.PI / 180.0 * 6378137.0;
        double a = lat * Math.PI / 180.0;
        double y = 3189068.5 * Math.log((1.0 + Math.sin(a)) / (1.0 - Math.sin(a)));
        return new double[]{x, y};
    }

    public static double[] mercator2LngLat(double[] mercator) {
        return JTSUtil.mercator2LngLat(mercator[0], mercator[1]);
    }

    public static double[] mercator2LngLat(double x, double y) {
        double lng = x / 111319.49079327358;
        double lat = y / 111319.49079327358;
        lat = 57.29577951308232 * (2.0 * Math.atan(Math.exp(lat * Math.PI / 180.0)) - 1.5707963267948966);
        return new double[]{lng, lat};
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static <T extends Geometry> T mercator2LngLat(T mercator) {
        return (T)((Geometry)Common.cast(((GeometryConvertService)Objects.requireNonNull(CONVERT_SERVICE_LOADER.select(mercator))).toLngLat(mercator)));
    }

    public static <T extends Geometry> T lngLat2Mercator(T lngLat) {
        return (T)((Geometry)Common.cast(((GeometryConvertService)Objects.requireNonNull(CONVERT_SERVICE_LOADER.select(lngLat))).toMercator(lngLat)));
    }

    public static Coordinate mercator2LngLat(Coordinate mercator) {
        double[] g = JTSUtil.mercator2LngLat(mercator.getX(), mercator.getY());
        return new Coordinate(g[0], g[1]);
    }

    public static Coordinate lngLat2Mercator(Coordinate lngLat) {
        double[] g = JTSUtil.lngLat2Mercator(lngLat.getX(), lngLat.getY());
        return new Coordinate(g[0], g[1]);
    }

    public static Coordinate[] mercator2LngLat(Coordinate[] mercator) {
        Coordinate[] coordinates = new Coordinate[mercator.length];
        for (int i = 0; i < coordinates.length; ++i) {
            coordinates[i] = JTSUtil.mercator2LngLat(mercator[i]);
        }
        return coordinates;
    }

    public static Coordinate[] lngLat2Mercator(Coordinate[] lngLat) {
        Coordinate[] coordinates = new Coordinate[lngLat.length];
        for (int i = 0; i < coordinates.length; ++i) {
            coordinates[i] = JTSUtil.lngLat2Mercator(lngLat[i]);
        }
        return coordinates;
    }
}

