/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.jts;

import java.util.ArrayList;
import java.util.Objects;
import org.coodex.jts.GeometryConvertService;
import org.coodex.util.Common;
import org.coodex.util.LazySelectableServiceLoader;
import org.coodex.util.SelectableServiceLoader;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class JTSUtil {
    public static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();
    private static final SelectableServiceLoader<Geometry, GeometryConvertService<Geometry>> CONVERT_SERVICE_LOADER = new LazySelectableServiceLoader<Geometry, GeometryConvertService<Geometry>>(){};
    private static final double EARTH_RADIUS = 6378137.0;

    public static double[] lngLat2Mercator(double[] lngLat) {
        return JTSUtil.lngLat2Mercator(lngLat[0], lngLat[1]);
    }

    public static double[] lngLat2Mercator(double lng, double lat) {
        double x = lng * Math.PI / 180.0 * 6378137.0;
        double a = lat * Math.PI / 180.0;
        double y = 3189068.5 * Math.log((1.0 + Math.sin(a)) / (1.0 - Math.sin(a)));
        return new double[]{x, y};
    }

    public static double[] mercator2LngLat(double[] mercator) {
        return JTSUtil.mercator2LngLat(mercator[0], mercator[1]);
    }

    public static double[] mercator2LngLat(double x, double y) {
        double lng = x / 111319.49079327358;
        double lat = y / 111319.49079327358;
        lat = 57.29577951308232 * (2.0 * Math.atan(Math.exp(lat * Math.PI / 180.0)) - 1.5707963267948966);
        return new double[]{lng, lat};
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static <T extends Geometry> T mercator2LngLat(T mercator) {
        return (T)((Geometry)Common.cast(((GeometryConvertService)Objects.requireNonNull(CONVERT_SERVICE_LOADER.select(mercator))).toLngLat(mercator)));
    }

    public static <T extends Geometry> T lngLat2Mercator(T lngLat) {
        return (T)((Geometry)Common.cast(((GeometryConvertService)Objects.requireNonNull(CONVERT_SERVICE_LOADER.select(lngLat))).toMercator(lngLat)));
    }

    public static Coordinate mercator2LngLat(Coordinate mercator) {
        double[] g = JTSUtil.mercator2LngLat(mercator.getX(), mercator.getY());
        return new Coordinate(g[0], g[1]);
    }

    public static Coordinate lngLat2Mercator(Coordinate lngLat) {
        double[] g = JTSUtil.lngLat2Mercator(lngLat.getX(), lngLat.getY());
        return new Coordinate(g[0], g[1]);
    }

    public static Coordinate[] mercator2LngLat(Coordinate[] mercator) {
        Coordinate[] coordinates = new Coordinate[mercator.length];
        for (int i = 0; i < coordinates.length; ++i) {
            coordinates[i] = JTSUtil.mercator2LngLat(mercator[i]);
        }
        return coordinates;
    }

    public static Coordinate[] lngLat2Mercator(Coordinate[] lngLat) {
        Coordinate[] coordinates = new Coordinate[lngLat.length];
        for (int i = 0; i < coordinates.length; ++i) {
            coordinates[i] = JTSUtil.lngLat2Mercator(lngLat[i]);
        }
        return coordinates;
    }

    public static <T extends Geometry> T crop(T geometry, double threshold) {
        if (geometry instanceof MultiPolygon) {
            Geometry g = null;
            int l = geometry.getNumGeometries();
            for (int i = 0; i < l; ++i) {
                g = g != null ? g.union(JTSUtil.crop(geometry.getGeometryN(i), threshold)) : geometry.getGeometryN(i);
            }
            return (T)((Geometry)Common.cast(g));
        }
        if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            if (polygon.getNumInteriorRing() == 0) {
                return geometry;
            }
            double outer = JTSUtil.areaOf(polygon.getExteriorRing());
            ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
            int l = polygon.getNumInteriorRing();
            for (int i = 0; i < l; ++i) {
                LinearRing hole = polygon.getInteriorRingN(i);
                if (!(JTSUtil.areaOf(hole) / outer > threshold)) continue;
                holes.add(hole);
            }
            return (T)((Geometry)Common.cast((Object)(holes.size() == 0 ? GEOMETRY_FACTORY.createPolygon(polygon.getExteriorRing()) : GEOMETRY_FACTORY.createPolygon(polygon.getExteriorRing(), holes.toArray(new LinearRing[0])))));
        }
        return geometry;
    }

    public static double areaOf(Geometry lngLat) {
        if (lngLat instanceof MultiPolygon) {
            return JTSUtil.areaOf((MultiPolygon)lngLat);
        }
        if (lngLat instanceof Polygon) {
            return JTSUtil.areaOf((Polygon)lngLat);
        }
        if (lngLat instanceof LinearRing) {
            return JTSUtil.areaOf((LinearRing)lngLat);
        }
        return 0.0;
    }

    private static double areaOf(MultiPolygon multiPolygon) {
        double area = 0.0;
        int size = multiPolygon.getNumGeometries();
        for (int i = 0; i < size; ++i) {
            area += JTSUtil.areaOf(multiPolygon.getGeometryN(i));
        }
        return area;
    }

    private static double areaOf(Polygon polygon) {
        double area = JTSUtil.areaOf(polygon.getExteriorRing());
        int holes = polygon.getNumInteriorRing();
        for (int i = 0; i < holes; ++i) {
            area -= JTSUtil.areaOf(polygon.getInteriorRingN(i));
        }
        return Math.max(0.0, area);
    }

    private static boolean isLngLat(Geometry geometry) {
        Coordinate c = geometry.getCoordinate();
        return c == null || JTSUtil.isLngLat(c);
    }

    private static boolean isLngLat(Coordinate coordinate) {
        return coordinate.getX() < 180.0 && coordinate.getX() > -180.0 && coordinate.getY() < 90.0 && coordinate.getY() > -90.0;
    }

    private static double areaOf(LinearRing lngLatRing) {
        if (!JTSUtil.isLngLat((Geometry)lngLatRing)) {
            lngLatRing = JTSUtil.mercator2LngLat(lngLatRing);
        }
        Coordinate[] coordinates = lngLatRing.getCoordinates();
        double x = 180.0;
        double y = 180.0;
        for (Coordinate c : coordinates) {
            x = Math.min(x, c.getX());
            y = Math.min(y, c.getY());
        }
        Coordinate[] newPoints = new Coordinate[coordinates.length];
        for (Coordinate c : coordinates) {
            newPoints[i] = new Coordinate(JTSUtil.distanceLngLat(x, y, c.getX(), y), JTSUtil.distanceLngLat(x, y, x, c.getY()));
        }
        return GEOMETRY_FACTORY.createPolygon(newPoints).getArea();
    }

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static double distanceLngLat(double x1, double y1, double x2, double y2) {
        double radLat1 = JTSUtil.rad(y1);
        double radLat2 = JTSUtil.rad(y2);
        double a = radLat1 - radLat2;
        double b = JTSUtil.rad(x1) - JTSUtil.rad(x2);
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        return s * 6378137.0;
    }
}

