/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.jts.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.coodex.jts.GeometryConvertService;
import org.coodex.jts.JTSUtil;
import org.coodex.util.Common;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class GeometryCollectionConverter
implements GeometryConvertService<GeometryCollection> {
    private static final GCCFunction<MultiPoint, Point> MULTI_POINT_POINT_GCC_FUNCTION = new GCCFunction<MultiPoint, Point>(){

        @Override
        protected MultiPoint create(List<Point> geometries) {
            return new MultiPoint(geometries.toArray(new Point[0]), JTSUtil.GEOMETRY_FACTORY);
        }
    };
    private static final GCCFunction<MultiLineString, LineString> MULTI_LINE_STRING_LINE_STRING_GCC_FUNCTION = new GCCFunction<MultiLineString, LineString>(){

        @Override
        protected MultiLineString create(List<LineString> geometries) {
            return new MultiLineString(geometries.toArray(new LineString[0]), JTSUtil.GEOMETRY_FACTORY);
        }
    };
    private static final GCCFunction<MultiPolygon, Polygon> MULTI_POLYGON_POLYGON_GCC_FUNCTION = new GCCFunction<MultiPolygon, Polygon>(){

        @Override
        protected MultiPolygon create(List<Polygon> geometries) {
            return new MultiPolygon(geometries.toArray(new Polygon[0]), JTSUtil.GEOMETRY_FACTORY);
        }
    };
    private static final GCCFunction<GeometryCollection, Geometry> DEFAULT = new GCCFunction<GeometryCollection, Geometry>(){

        @Override
        protected GeometryCollection create(List<Geometry> geometries) {
            return new GeometryCollection(geometries.toArray(new Geometry[0]), JTSUtil.GEOMETRY_FACTORY);
        }
    };

    @Override
    public GeometryCollection toMercator(GeometryCollection source) {
        if (source instanceof MultiPoint) {
            return MULTI_POINT_POINT_GCC_FUNCTION.apply((MultiPoint)source, JTSUtil::lngLat2Mercator);
        }
        if (source instanceof MultiLineString) {
            return MULTI_LINE_STRING_LINE_STRING_GCC_FUNCTION.apply((MultiLineString)source, JTSUtil::lngLat2Mercator);
        }
        if (source instanceof MultiPolygon) {
            return MULTI_POLYGON_POLYGON_GCC_FUNCTION.apply((MultiPolygon)source, JTSUtil::lngLat2Mercator);
        }
        return DEFAULT.apply(source, JTSUtil::lngLat2Mercator);
    }

    @Override
    public GeometryCollection toLngLat(GeometryCollection mercator) {
        if (mercator instanceof MultiPoint) {
            return MULTI_POINT_POINT_GCC_FUNCTION.apply((MultiPoint)mercator, JTSUtil::mercator2LngLat);
        }
        if (mercator instanceof MultiLineString) {
            return MULTI_LINE_STRING_LINE_STRING_GCC_FUNCTION.apply((MultiLineString)mercator, JTSUtil::mercator2LngLat);
        }
        if (mercator instanceof MultiPolygon) {
            return MULTI_POLYGON_POLYGON_GCC_FUNCTION.apply((MultiPolygon)mercator, JTSUtil::mercator2LngLat);
        }
        return DEFAULT.apply(mercator, JTSUtil::mercator2LngLat);
    }

    public boolean accept(GeometryCollection param) {
        return true;
    }

    static abstract class GCCFunction<M extends GeometryCollection, S extends Geometry>
    implements BiFunction<M, Function<S, S>, M> {
        GCCFunction() {
        }

        protected abstract M create(List<S> var1);

        @Override
        public M apply(M source, Function<S, S> func) {
            ArrayList<S> geometries = new ArrayList<S>();
            for (int i = 0; i < source.getNumGeometries(); ++i) {
                geometries.add(func.apply(Common.cast((Object)source.getGeometryN(i))));
            }
            return this.create(geometries);
        }
    }
}

