/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.jts.impl;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.coodex.jts.GeometryConvertService;
import org.coodex.jts.JTSUtil;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;

public class LineStringConverter
implements GeometryConvertService<LineString> {
    static final BiFunction<LineString, Function<Coordinate[], Coordinate[]>, LineString> LINESTRING_CONVERTER_FUNCTION = (source, func) -> source instanceof LinearRing ? JTSUtil.GEOMETRY_FACTORY.createLinearRing((Coordinate[])func.apply(source.getCoordinates())) : JTSUtil.GEOMETRY_FACTORY.createLineString((Coordinate[])func.apply(source.getCoordinates()));

    @Override
    public LineString toMercator(LineString lngLat) {
        return LINESTRING_CONVERTER_FUNCTION.apply(lngLat, JTSUtil::lngLat2Mercator);
    }

    @Override
    public LineString toLngLat(LineString mercator) {
        return LINESTRING_CONVERTER_FUNCTION.apply(mercator, JTSUtil::mercator2LngLat);
    }

    public boolean accept(LineString param) {
        return true;
    }
}

