/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.jts;

import java.util.Arrays;
import org.coodex.jts.JTSUtil;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.simplify.DouglasPeuckerSimplifier;

public class MetersGeometry {
    private final Coordinate base;
    private Geometry geometry;

    MetersGeometry(Geometry lngLat) {
        this.geometry = lngLat.copy();
        Coordinate[] coordinates = this.geometry.getCoordinates();
        double baseX = 180.0;
        double baseY = 180.0;
        for (int i = 0; i < coordinates.length; ++i) {
            Coordinate c = coordinates[i];
            if (baseX > c.getX()) {
                baseX = c.getX();
            }
            if (!(baseY > c.getY())) continue;
            baseY = c.getY();
        }
        this.base = new Coordinate(baseX, baseY);
        for (Coordinate c : coordinates) {
            Coordinate t = new Coordinate(JTSUtil.distanceLngLat(baseX, baseY, c.getX(), baseY), JTSUtil.distanceLngLat(baseX, baseY, baseX, c.getY()));
            c.setX(t.getX());
            c.setY(t.getY());
        }
    }

    MetersGeometry(Geometry meters, Coordinate base) {
        this.base = base;
        this.geometry = meters.copy();
    }

    public MetersGeometry xMove(double distance) {
        for (Coordinate c : this.geometry.getCoordinates()) {
            c.setX(c.getX() + distance);
        }
        return this;
    }

    public MetersGeometry yMove(double distance) {
        for (Coordinate c : this.geometry.getCoordinates()) {
            c.setY(c.getY() + distance);
        }
        return this;
    }

    public MetersGeometry move(double distance, double degree) {
        for (Coordinate c : this.geometry.getCoordinates()) {
            c.setX(c.getX() + Math.cos(degree / 180.0 * Math.PI) * distance);
            c.setY(c.getY() + Math.sin(degree / 180.0 * Math.PI) * distance);
        }
        return this;
    }

    public MetersGeometry simplify(double dt) {
        this.geometry = DouglasPeuckerSimplifier.simplify((Geometry)this.geometry, (double)dt);
        return this;
    }

    public MetersGeometry buffer(double distance) {
        this.geometry = this.geometry.buffer(distance);
        return this;
    }

    public MetersGeometry buffer(double distance, int quadrantSegments) {
        this.geometry = this.geometry.buffer(distance, quadrantSegments);
        return this;
    }

    public MetersGeometry buffer(double distance, int quadrantSegments, int endCapStyle) {
        this.geometry = this.geometry.buffer(distance, quadrantSegments, endCapStyle);
        return this;
    }

    public double getArea() {
        return this.geometry.getArea();
    }

    public Geometry toLngLat() {
        Geometry lngLat = this.geometry.copy();
        Arrays.stream(lngLat.getCoordinates()).forEach(coord -> {
            double x = coord.getX();
            double y = coord.getY();
            coord.setX(JTSUtil.xMove(this.base, x));
            coord.setY(JTSUtil.yMove(this.base, y));
        });
        return lngLat;
    }

    public MetersGeometry copy() {
        return new MetersGeometry(this.geometry, this.base);
    }
}

