/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.jts.coord;

import java.util.Objects;
import org.coodex.jts.coord.Coord;
import org.coodex.jts.coord.CoordConverter;
import org.coodex.util.LazySelectableServiceLoader;
import org.coodex.util.SelectableServiceLoader;

public class CoordUtil {
    static final double EE = 0.006693421622965943;
    static final double A = 6378245.0;
    private static final SelectableServiceLoader<Coord, CoordConverter> CONVERTORS = new LazySelectableServiceLoader<Coord, CoordConverter>(){};

    static double transformlat(double lng, double lat) {
        double ret = -100.0 + 2.0 * lng + 3.0 * lat + 0.2 * lat * lat + 0.1 * lng * lat + 0.2 * Math.sqrt(Math.abs(lng));
        ret = CoordUtil.getRet(lng, lat, ret);
        return ret += (160.0 * Math.sin(lat / 12.0 * Math.PI) + 320.0 * Math.sin(lat * Math.PI / 30.0)) * 2.0 / 3.0;
    }

    static double getRet(double lng, double lat, double ret) {
        ret += (20.0 * Math.sin(6.0 * lng * Math.PI) + 20.0 * Math.sin(2.0 * lng * Math.PI)) * 2.0 / 3.0;
        return ret += (20.0 * Math.sin(lat * Math.PI) + 40.0 * Math.sin(lat / 3.0 * Math.PI)) * 2.0 / 3.0;
    }

    static double transformlng(double lng, double lat) {
        double ret = 300.0 + lng + 2.0 * lat + 0.1 * lng * lng + 0.1 * lng * lat + 0.1 * Math.sqrt(Math.abs(lng));
        ret = CoordUtil.getRet(lng, lng, ret);
        return ret += (150.0 * Math.sin(lng / 12.0 * Math.PI) + 300.0 * Math.sin(lng / 30.0 * Math.PI)) * 2.0 / 3.0;
    }

    public static double[] convert(double[] pt, Coord from, Coord to) {
        if (Objects.equals((Object)from, (Object)to)) {
            return pt;
        }
        CoordConverter cFrom = (CoordConverter)CONVERTORS.select((Object)from);
        CoordConverter cTo = (CoordConverter)CONVERTORS.select((Object)to);
        return cTo.from84(cFrom.to84(pt));
    }
}

