/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.jts;

import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import org.coodex.jts.AreaOf;
import org.coodex.jts.CoordSys;
import org.coodex.jts.GeometryConvertService;
import org.coodex.jts.MetersGeometry;
import org.coodex.util.Common;
import org.coodex.util.LazySelectableServiceLoader;
import org.coodex.util.SelectableServiceLoader;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class JTSUtil {
    public static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();
    private static final SelectableServiceLoader<Geometry, GeometryConvertService<Geometry>> CONVERT_SERVICE_LOADER = new LazySelectableServiceLoader<Geometry, GeometryConvertService<Geometry>>(){};
    private static final SelectableServiceLoader<CoordSys.CoordType, AreaOf> AREA_OF_SERVICE = new LazySelectableServiceLoader<CoordSys.CoordType, AreaOf>(){};
    private static final double EARTH_RADIUS = 6378137.0;

    private JTSUtil() {
    }

    public static double[] lngLat2Mercator(double[] lngLat) {
        return JTSUtil.lngLat2Mercator(lngLat[0], lngLat[1]);
    }

    public static double[] lngLat2Mercator(double lng, double lat) {
        double x = lng * Math.PI / 180.0 * 6378137.0;
        double a = lat * Math.PI / 180.0;
        double y = 3189068.5 * Math.log((1.0 + Math.sin(a)) / (1.0 - Math.sin(a)));
        return new double[]{x, y};
    }

    public static double[] mercator2LngLat(double[] mercator) {
        return JTSUtil.mercator2LngLat(mercator[0], mercator[1]);
    }

    public static double[] mercator2LngLat(double x, double y) {
        double lng = x / 111319.49079327358;
        double lat = y / 111319.49079327358;
        lat = 57.29577951308232 * (2.0 * Math.atan(Math.exp(lat * Math.PI / 180.0)) - 1.5707963267948966);
        return new double[]{lng, lat};
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static <T extends Geometry> T mercator2LngLat(T mercator) {
        return (T)((Geometry)Common.cast(Objects.requireNonNull((GeometryConvertService)CONVERT_SERVICE_LOADER.select(mercator)).toLngLat(mercator)));
    }

    public static <T extends Geometry> T lngLat2Mercator(T lngLat) {
        return (T)((Geometry)Common.cast(Objects.requireNonNull((GeometryConvertService)CONVERT_SERVICE_LOADER.select(lngLat)).toMercator(lngLat)));
    }

    public static Coordinate mercator2LngLat(Coordinate mercator) {
        double[] g = JTSUtil.mercator2LngLat(mercator.getX(), mercator.getY());
        return new Coordinate(g[0], g[1]);
    }

    public static Coordinate lngLat2Mercator(Coordinate lngLat) {
        double[] g = JTSUtil.lngLat2Mercator(lngLat.getX(), lngLat.getY());
        return new Coordinate(g[0], g[1]);
    }

    public static Coordinate[] mercator2LngLat(Coordinate[] mercator) {
        Coordinate[] coordinates = new Coordinate[mercator.length];
        for (int i = 0; i < coordinates.length; ++i) {
            coordinates[i] = JTSUtil.mercator2LngLat(mercator[i]);
        }
        return coordinates;
    }

    public static Coordinate[] lngLat2Mercator(Coordinate[] lngLat) {
        Coordinate[] coordinates = new Coordinate[lngLat.length];
        for (int i = 0; i < coordinates.length; ++i) {
            coordinates[i] = JTSUtil.lngLat2Mercator(lngLat[i]);
        }
        return coordinates;
    }

    public static Geometry crop(Geometry geometry, double threshold) {
        if (geometry instanceof MultiPolygon) {
            return JTSUtil.cropMultiPolygon(geometry, threshold);
        }
        if (geometry instanceof Polygon) {
            return JTSUtil.cropPolygon(geometry, threshold);
        }
        if (geometry instanceof GeometryCollection) {
            return JTSUtil.crop(JTSUtil.get2DGeometry(geometry), threshold);
        }
        return geometry;
    }

    private static Geometry cropPolygon(Geometry geometry, double threshold) {
        if (geometry == null || geometry.isEmpty()) {
            return geometry;
        }
        Polygon polygon = (Polygon)geometry;
        if (polygon.getNumInteriorRing() == 0) {
            return geometry;
        }
        double outer = polygon.getExteriorRing().getArea();
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        int l = polygon.getNumInteriorRing();
        for (int i = 0; i < l; ++i) {
            LinearRing hole = polygon.getInteriorRingN(i);
            if (!(hole.getArea() / outer > threshold)) continue;
            holes.add(hole);
        }
        return (Geometry)Common.cast((Object)(holes.size() == 0 ? GEOMETRY_FACTORY.createPolygon(polygon.getExteriorRing()) : GEOMETRY_FACTORY.createPolygon(polygon.getExteriorRing(), holes.toArray(new LinearRing[0]))));
    }

    private static Geometry cropMultiPolygon(Geometry geometry, double threshold) {
        Geometry g = null;
        int l = geometry.getNumGeometries();
        for (int i = 0; i < l; ++i) {
            g = g != null ? g.union(JTSUtil.crop(geometry.getGeometryN(i), threshold)) : geometry.getGeometryN(i);
        }
        return g;
    }

    public static Geometry union2D(Geometry g1, Geometry g2) {
        return JTSUtil.get2DGeometry(g1).union(JTSUtil.get2DGeometry(g2));
    }

    public static Geometry intersection2D(Geometry g1, Geometry g2) {
        return JTSUtil.get2DGeometry(JTSUtil.get2DGeometry(g1).intersection(JTSUtil.get2DGeometry(g2)));
    }

    public static Geometry difference2D(Geometry g1, Geometry g2) {
        return JTSUtil.get2DGeometry(g1).difference(JTSUtil.get2DGeometry(g2));
    }

    public static Geometry symDifference2D(Geometry g1, Geometry g2) {
        return JTSUtil.get2DGeometry(g1).symDifference(JTSUtil.get2DGeometry(g2));
    }

    public static double yMove(Coordinate o, double distance) {
        return distance / 6378137.0 / Math.PI * 180.0 + o.getY();
    }

    public static double xMove(Coordinate o, double distance) {
        return distance / 6378137.0 / Math.cos(JTSUtil.rad(o.getY())) * 180.0 / Math.PI + o.getX();
    }

    public static Coordinate move(Coordinate o, double distance, double degree) {
        return new Coordinate(JTSUtil.xMove(o, Math.cos(degree / 180.0 * Math.PI) * distance), JTSUtil.yMove(o, Math.sin(degree / 180.0 * Math.PI) * distance));
    }

    public static double areaOf(Geometry geometry, CoordSys.CoordType coordType) {
        return ((AreaOf)AREA_OF_SERVICE.select((Object)coordType)).areaOf(geometry);
    }

    @Deprecated
    public static double areaOf(Geometry lngLat) {
        return JTSUtil.areaOf(lngLat, CoordSys.CoordType.COMPATIBLE);
    }

    public static Geometry get2DGeometry(Geometry geometry) {
        if (geometry instanceof Polygon || geometry instanceof MultiPolygon) {
            return geometry;
        }
        if (geometry instanceof GeometryCollection) {
            Geometry polygon = null;
            int l = geometry.getNumGeometries();
            for (int i = 0; i < l; ++i) {
                Geometry sub = JTSUtil.get2DGeometry(geometry.getGeometryN(i));
                if (!(sub.getArea() > 0.0)) continue;
                polygon = polygon == null ? sub : polygon.union(sub);
            }
            if (polygon != null) {
                return polygon;
            }
        }
        return GEOMETRY_FACTORY.createEmpty(2);
    }

    static boolean isLngLat(Geometry geometry) {
        Coordinate c = geometry.getCoordinate();
        return c == null || JTSUtil.isLngLat(c);
    }

    static boolean isLngLat(Coordinate coordinate) {
        return coordinate.getX() < 180.0 && coordinate.getX() > -180.0 && coordinate.getY() < 90.0 && coordinate.getY() > -90.0;
    }

    private static double rad(double angle) {
        return angle * Math.PI / 180.0;
    }

    public static double distanceLngLat(Coordinate c1, Coordinate c2) {
        return JTSUtil.distanceLngLat(c1.getX(), c1.getY(), c2.getX(), c2.getY());
    }

    public static double distanceLngLat(double x1, double y1, double x2, double y2) {
        double radLat1 = JTSUtil.rad(y1);
        double radLat2 = JTSUtil.rad(y2);
        double a = radLat1 - radLat2;
        double b = JTSUtil.rad(x1) - JTSUtil.rad(x2);
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        return s * 6378137.0;
    }

    public static <T> double shoelaceFormula(T[] points, Function<T, Double> xGetter, Function<T, Double> yGetter) {
        if (points.length < 3) {
            return 0.0;
        }
        double sum = 0.0;
        double x0 = xGetter.apply(points[0]);
        for (int i = 1; i < points.length - 1; ++i) {
            double x = xGetter.apply(points[i]) - x0;
            double y1 = yGetter.apply(points[i + 1]);
            double y2 = yGetter.apply(points[i - 1]);
            sum += x * (y2 - y1);
        }
        return Math.abs(sum / 2.0);
    }

    public static double shoelaceFormula(Coordinate[] coordinates) {
        return JTSUtil.shoelaceFormula(coordinates, Coordinate::getX, Coordinate::getY);
    }

    public static Geometry wktToGeometry(String wkt) {
        WKTReader wktReader = new WKTReader(GEOMETRY_FACTORY);
        try {
            return wktReader.read(wkt);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static MetersGeometry buildMeterGeometry(Geometry geometry, CoordSys.CoordType coordType) {
        switch (coordType) {
            case MERCATOR: {
                return new MetersGeometry(JTSUtil.mercator2LngLat(geometry));
            }
            case LNG_LAT: {
                return new MetersGeometry(geometry);
            }
            case METERS: {
                return new MetersGeometry(geometry, new Coordinate(0.0, 0.0));
            }
            case COMPATIBLE: {
                return JTSUtil.isLngLat(geometry) ? new MetersGeometry(geometry) : new MetersGeometry(JTSUtil.mercator2LngLat(geometry));
            }
        }
        throw new UnsupportedOperationException(coordType.toString());
    }
}

