/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.jts.impl;

import org.coodex.functional.BiFunction;
import org.coodex.functional.Function;
import org.coodex.jts.GeometryConvertService;
import org.coodex.jts.JTSUtil;
import org.coodex.jts.impl.Lambdas;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;

public class LineStringConverter
implements GeometryConvertService<LineString> {
    static final BiFunction<LineString, Function<Coordinate[], Coordinate[]>, LineString> LINESTRING_CONVERTER_FUNCTION = new BiFunction<LineString, Function<Coordinate[], Coordinate[]>, LineString>(){

        public LineString apply(LineString source, Function<Coordinate[], Coordinate[]> func) {
            return source instanceof LinearRing ? JTSUtil.GEOMETRY_FACTORY.createLinearRing((Coordinate[])func.apply((Object)source.getCoordinates())) : JTSUtil.GEOMETRY_FACTORY.createLineString((Coordinate[])func.apply((Object)source.getCoordinates()));
        }
    };

    @Override
    public LineString toMercator(LineString lngLat) {
        return (LineString)LINESTRING_CONVERTER_FUNCTION.apply((Object)lngLat, Lambdas.lnglat2Mercator_Coords);
    }

    @Override
    public LineString toLngLat(LineString mercator) {
        return (LineString)LINESTRING_CONVERTER_FUNCTION.apply((Object)mercator, Lambdas.mercator2LanLat_Coords);
    }

    public boolean accept(LineString param) {
        return true;
    }
}

