/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.jts;

import org.coodex.jts.AreaOf;
import org.coodex.jts.JTSUtil;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public abstract class AbstractAreaOf
implements AreaOf {
    @Override
    public double areaOf(Geometry geometry) {
        if (geometry instanceof MultiPolygon) {
            return this.areaOf((MultiPolygon)geometry);
        }
        if (geometry instanceof Polygon) {
            return this.areaOf((Polygon)geometry);
        }
        if (geometry instanceof LinearRing) {
            return this.areaOf((LinearRing)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return this.areaOf(JTSUtil.get2DGeometry(geometry));
        }
        return 0.0;
    }

    @Override
    public double areaOf(MultiPolygon multiPolygon) {
        double area = 0.0;
        int size = multiPolygon.getNumGeometries();
        for (int i = 0; i < size; ++i) {
            area += this.areaOf(multiPolygon.getGeometryN(i));
        }
        return area;
    }

    @Override
    public double areaOf(Polygon polygon) {
        double area = this.areaOf(polygon.getExteriorRing());
        int holes = polygon.getNumInteriorRing();
        for (int i = 0; i < holes; ++i) {
            area -= this.areaOf(polygon.getInteriorRingN(i));
        }
        return Math.max(0.0, area);
    }
}

