/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.jts.coord;

import java.util.Objects;
import org.coodex.jts.coord.Coord;
import org.coodex.jts.coord.CoordConverterGCJ02;

public class CoordConverterBD09
extends CoordConverterGCJ02 {
    private static final double x_pi = 52.35987755982988;

    @Override
    public double[] to84(double[] pt) {
        double[] gcj = this.bd09ToGCJ02(pt[0], pt[1]);
        return super.to84(gcj);
    }

    @Override
    public double[] from84(double[] pt84) {
        double[] gcj = super.from84(pt84);
        return this.gcj02ToBD09(gcj[0], gcj[1]);
    }

    private double[] gcj02ToBD09(double lng, double lat) {
        double z = Math.sqrt(lng * lng + lat * lat) + 2.0E-5 * Math.sin(lat * 52.35987755982988);
        double theta = Math.atan2(lat, lng) + 3.0E-6 * Math.cos(lng * 52.35987755982988);
        double bd_lng = z * Math.cos(theta) + 0.0065;
        double bd_lat = z * Math.sin(theta) + 0.006;
        return new double[]{bd_lng, bd_lat};
    }

    public double[] bd09ToGCJ02(double bd_lon, double bd_lat) {
        double x = bd_lon - 0.0065;
        double y = bd_lat - 0.006;
        double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * 52.35987755982988);
        double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * 52.35987755982988);
        double gg_lng = z * Math.cos(theta);
        double gg_lat = z * Math.sin(theta);
        return new double[]{gg_lng, gg_lat};
    }

    @Override
    public boolean accept(Coord param) {
        return Objects.equals((Object)param, (Object)Coord.BD09);
    }
}

