/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.jts.impl;

import java.util.ArrayList;
import java.util.List;
import org.coodex.functional.BiFunction;
import org.coodex.functional.Function;
import org.coodex.jts.GeometryConvertService;
import org.coodex.jts.JTSUtil;
import org.coodex.jts.impl.Lambdas;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class GeometryCollectionConverter
implements GeometryConvertService<GeometryCollection> {
    private static final GCCFunction<MultiPoint, Point> MULTI_POINT_POINT_GCC_FUNCTION = new BaseGCCFunction<MultiPoint, Point>(){

        @Override
        public MultiPoint create(List<Point> geometries) {
            return new MultiPoint(geometries.toArray(new Point[0]), JTSUtil.GEOMETRY_FACTORY);
        }
    };
    private static final GCCFunction<MultiLineString, LineString> MULTI_LINE_STRING_LINE_STRING_GCC_FUNCTION = new BaseGCCFunction<MultiLineString, LineString>(){

        @Override
        public MultiLineString create(List<LineString> geometries) {
            return new MultiLineString(geometries.toArray(new LineString[0]), JTSUtil.GEOMETRY_FACTORY);
        }
    };
    private static final GCCFunction<MultiPolygon, Polygon> MULTI_POLYGON_POLYGON_GCC_FUNCTION = new BaseGCCFunction<MultiPolygon, Polygon>(){

        @Override
        public MultiPolygon create(List<Polygon> geometries) {
            return new MultiPolygon(geometries.toArray(new Polygon[0]), JTSUtil.GEOMETRY_FACTORY);
        }
    };
    private static final GCCFunction<GeometryCollection, Geometry> DEFAULT = new BaseGCCFunction<GeometryCollection, Geometry>(){

        @Override
        public GeometryCollection create(List<Geometry> geometries) {
            return new GeometryCollection(geometries.toArray(new Geometry[0]), JTSUtil.GEOMETRY_FACTORY);
        }
    };

    @Override
    public GeometryCollection toMercator(GeometryCollection source) {
        if (source instanceof MultiPoint) {
            return MULTI_POINT_POINT_GCC_FUNCTION.apply((MultiPoint)source, Lambdas.lngLat2Mercator_Point);
        }
        if (source instanceof MultiLineString) {
            return MULTI_LINE_STRING_LINE_STRING_GCC_FUNCTION.apply((MultiLineString)source, Lambdas.lngLat2Mercator_LineString);
        }
        if (source instanceof MultiPolygon) {
            return MULTI_POLYGON_POLYGON_GCC_FUNCTION.apply((MultiPolygon)source, Lambdas.lngLat2Mercator_Polygon);
        }
        return DEFAULT.apply(source, Lambdas.lngLat2Mercator);
    }

    @Override
    public GeometryCollection toLngLat(GeometryCollection mercator) {
        if (mercator instanceof MultiPoint) {
            return MULTI_POINT_POINT_GCC_FUNCTION.apply((MultiPoint)mercator, Lambdas.mercator2LngLat_Point);
        }
        if (mercator instanceof MultiLineString) {
            return MULTI_LINE_STRING_LINE_STRING_GCC_FUNCTION.apply((MultiLineString)mercator, Lambdas.mercator2LngLat_LineString);
        }
        if (mercator instanceof MultiPolygon) {
            return MULTI_POLYGON_POLYGON_GCC_FUNCTION.apply((MultiPolygon)mercator, Lambdas.mercator2LngLat_Polygon);
        }
        return DEFAULT.apply(mercator, Lambdas.mercator2LngLat);
    }

    public boolean accept(GeometryCollection param) {
        return true;
    }

    static interface GCCFunction<M extends GeometryCollection, S extends Geometry>
    extends BiFunction<M, Function<S, S>, M> {
        public M create(List<S> var1);

        public M apply(M var1, Function<S, S> var2);
    }

    public static abstract class BaseGCCFunction<M extends GeometryCollection, S extends Geometry>
    implements GCCFunction<M, S> {
        @Override
        public M apply(M source, Function<S, S> func) {
            ArrayList<Object> geometries = new ArrayList<Object>();
            for (int i = 0; i < source.getNumGeometries(); ++i) {
                geometries.add(func.apply((Object)source.getGeometryN(i)));
            }
            return this.create(geometries);
        }
    }
}

