/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.jts.impl;

import java.util.ArrayList;
import org.coodex.functional.BiFunction;
import org.coodex.functional.Function;
import org.coodex.jts.GeometryConvertService;
import org.coodex.jts.JTSUtil;
import org.coodex.jts.impl.Lambdas;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

public class PolygonConverter
implements GeometryConvertService<Polygon> {
    static BiFunction<Polygon, Function<LinearRing, LinearRing>, Polygon> POLYGON_CONVERTER = new BiFunction<Polygon, Function<LinearRing, LinearRing>, Polygon>(){

        public Polygon apply(Polygon source, Function<LinearRing, LinearRing> func) {
            LinearRing shell = (LinearRing)func.apply((Object)source.getExteriorRing());
            ArrayList<Object> holes = new ArrayList<Object>();
            for (int i = 0; i < source.getNumInteriorRing(); ++i) {
                holes.add(func.apply((Object)source.getInteriorRingN(i)));
            }
            return !holes.isEmpty() ? JTSUtil.GEOMETRY_FACTORY.createPolygon(shell, holes.toArray(new LinearRing[0])) : JTSUtil.GEOMETRY_FACTORY.createPolygon(shell);
        }
    };

    @Override
    public Polygon toMercator(Polygon lngLat) {
        return (Polygon)POLYGON_CONVERTER.apply((Object)lngLat, Lambdas.lngLat2Mercator_LinearRing);
    }

    @Override
    public Polygon toLngLat(Polygon mercator) {
        return (Polygon)POLYGON_CONVERTER.apply((Object)mercator, Lambdas.mercator2LngLat_LinearRing);
    }

    public boolean accept(Polygon param) {
        return true;
    }
}

