/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.junit.enhance;

import java.lang.reflect.Proxy;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.coodex.junit.enhance.Context;
import org.coodex.junit.enhance.ContextProvider;
import org.coodex.junit.enhance.LoggerProvider;
import org.coodex.junit.enhance.Slf4jLoggerProvider;
import org.coodex.util.Clock;
import org.coodex.util.Common;
import org.coodex.util.LazySelectableServiceLoader;
import org.coodex.util.LazyServiceLoader;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtils {
    public static final Time TIME = new TimeImpl();
    static final ThreadLocal<Map<String, Object>> CONTEXT = new ThreadLocal();
    private static final Logger log = LoggerFactory.getLogger(TestUtils.class);
    private static final String KEY_TIMESTAMP = Common.getUUIDStr();
    private static final String KEY_NAME = Common.getUUIDStr();
    private static final LazyServiceLoader<LoggerProvider> LOGGER_PROVIDER_LOADER = new LazyServiceLoader<LoggerProvider>(Slf4jLoggerProvider::new){};
    public static final Logger logger = (Logger)Proxy.newProxyInstance(Logger.class.getClassLoader(), new Class[]{Logger.class}, (proxy, method, args) -> {
        if (args.length > 0) {
            return method.invoke((Object)TestUtils.getLogger(), args);
        }
        return method.invoke((Object)TestUtils.getLogger(), new Object[0]);
    });
    private static final LazySelectableServiceLoader<Description, ContextProvider> CONTEXT_PROVIDER_LOADER = new LazySelectableServiceLoader<Description, ContextProvider>(new ContextProvider(){

        @Override
        public Map<String, Object> createContext(Description description) {
            return new HashMap<String, Object>();
        }

        public boolean accept(Description param) {
            return true;
        }
    }){};

    private TestUtils() {
    }

    private static Logger getLogger() {
        String name = TestUtils.testCaseName();
        return Common.isBlank((String)name) ? log : ((LoggerProvider)LOGGER_PROVIDER_LOADER.get()).getLogger(name);
    }

    public static String testCaseName() {
        return (String)TestUtils._get(KEY_NAME);
    }

    static Map<String, Object> contextClone() {
        Map<String, Object> map = CONTEXT.get();
        if (map == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(map);
        result.put(KEY_TIMESTAMP, Clock.now());
        return result;
    }

    private static Map<String, Object> buildContext(Description description) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        CONTEXT_PROVIDER_LOADER.getAll().values().forEach(contextProvider -> {
            if (contextProvider.accept(description)) {
                map.putAll(contextProvider.createContext(description));
            }
        });
        Context.Data contextData = Context.Data.from((Context)description.getAnnotation(Context.class));
        map.put(KEY_NAME, Common.isBlank((String)contextData.name) ? description.getMethodName() : contextData.name);
        try {
            map.put(KEY_TIMESTAMP, Common.isBlank((String)contextData.timestamp) ? Clock.getCalendar() : Common.strToCalendar((String)contextData.timestamp, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        catch (Throwable th) {
            System.err.println("invalid timestamp: " + contextData.timestamp);
            map.put(KEY_TIMESTAMP, Clock.getCalendar());
        }
        return map;
    }

    static Statement wrap(final Statement statement, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                if (CONTEXT.get() != null) {
                    statement.evaluate();
                } else {
                    CONTEXT.set(TestUtils.buildContext(description));
                    try {
                        statement.evaluate();
                    }
                    finally {
                        CONTEXT.remove();
                    }
                }
            }
        };
    }

    public static void asyncRun(Runnable runnable) {
        Map<String, Object> objectMap = CONTEXT.get();
        if (objectMap == null) {
            new Thread(runnable).start();
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>(objectMap);
            map.put(KEY_TIMESTAMP, TestUtils.timestamp().clone());
            new Thread(() -> {
                CONTEXT.set(map);
                try {
                    runnable.run();
                }
                finally {
                    CONTEXT.remove();
                }
            }).start();
        }
    }

    static Calendar timestamp() {
        return TestUtils.get(KEY_TIMESTAMP, Clock::getCalendar);
    }

    private static <T> T _get(String key) {
        Map<String, Object> objectMap = CONTEXT.get();
        return (T)(objectMap == null ? null : objectMap.get(key));
    }

    public static <T> T get(String key, Class<T> tClass) {
        return TestUtils._get(key);
    }

    public static Object get(String key) {
        return TestUtils._get(key);
    }

    static <T> T get(String key, Supplier<T> supplier) {
        Map<String, Object> objectMap = CONTEXT.get();
        if (objectMap == null) {
            return supplier.get();
        }
        Object o = objectMap.get(key);
        if (o == null) {
            o = supplier.get();
            objectMap.put(key, o);
        }
        return (T)o;
    }

    static class TimeImpl
    implements Time {
        TimeImpl() {
        }

        private static Calendar truncate(int field) {
            Calendar calendar = TestUtils.timestamp();
            switch (field) {
                case 1: {
                    calendar.set(2, 0);
                }
                case 2: {
                    calendar.set(5, 1);
                }
                case 5: {
                    calendar.set(11, 0);
                }
                case 10: 
                case 11: {
                    calendar.set(12, 0);
                }
                case 12: {
                    calendar.set(13, 0);
                }
                case 13: {
                    calendar.set(14, 0);
                }
            }
            return calendar;
        }

        @Override
        public Time hours(int hours) {
            return this.go(hours, 0, 0);
        }

        @Override
        public Time minutes(int minutes) {
            return this.go(0, minutes, 0);
        }

        @Override
        public Time seconds(int seconds) {
            return this.go(0, 0, seconds);
        }

        @Override
        public Time go(int hours, int minutes, int seconds) {
            return this.go(0, 0, 0, hours, minutes, seconds);
        }

        @Override
        public Time go(int years, int months, int days, int hours, int minutes, int seconds) {
            Calendar calendar = TestUtils.timestamp();
            if (years > 0) {
                calendar.add(1, years);
            }
            if (months > 0) {
                calendar.add(2, months);
            }
            if (days > 0) {
                calendar.add(5, days);
            }
            if (hours > 0) {
                calendar.add(10, hours);
            }
            if (minutes > 0) {
                calendar.add(12, minutes);
            }
            if (seconds > 0) {
                calendar.add(13, seconds);
            }
            return this;
        }

        @Override
        public Time days(int days) {
            return this.go(0, 0, days, 0, 0, 0);
        }

        @Override
        public Time months(int months) {
            return this.go(0, months, 0, 0, 0, 0);
        }

        @Override
        public Time years(int years) {
            return this.go(years, 0, 0, 0, 0, 0);
        }

        private Time next(int amount, int field) {
            if (amount <= 0) {
                throw new IllegalArgumentException("amount must greater than 0.");
            }
            Calendar calendar = TimeImpl.truncate(field);
            calendar.add(field, amount);
            return this;
        }

        @Override
        public Time nextWeek() {
            return this.nextWeeks(1);
        }

        @Override
        public Time nextWeeks(int weeks) {
            if (weeks <= 0) {
                throw new IllegalArgumentException("amount must greater than 0.");
            }
            Calendar calendar = TimeImpl.truncate(5);
            int nextFirstDayDiff = (calendar.get(7) + 7 - calendar.getFirstDayOfWeek()) % 7;
            calendar.add(6, nextFirstDayDiff + (weeks - 1) * 7);
            return this;
        }

        @Override
        public Time nextMinute() {
            return this.nextMinutes(1);
        }

        @Override
        public Time nextMinutes(int minutes) {
            return this.next(minutes, 12);
        }

        @Override
        public Time nextHour() {
            return this.nextHours(1);
        }

        @Override
        public Time nextHours(int hours) {
            return this.next(hours, 11);
        }

        @Override
        public Time nextDay() {
            return this.nextDays(1);
        }

        @Override
        public Time nextDays(int days) {
            return this.next(days, 5);
        }

        @Override
        public Time nextMonth() {
            return this.nextMonths(1);
        }

        @Override
        public Time nextMonths(int months) {
            return this.next(months, 2);
        }

        @Override
        public Time nextYear() {
            return this.nextYears(1);
        }

        @Override
        public Time nextYears(int years) {
            return this.next(years, 1);
        }

        @Override
        public void go(int milliSeconds) {
            Calendar calendar = TestUtils.timestamp();
            calendar.add(14, milliSeconds);
        }

        public String toString() {
            return Common.calendarToStr((Calendar)TestUtils.timestamp());
        }
    }

    public static interface Time {
        public Time hours(int var1);

        public Time minutes(int var1);

        public Time seconds(int var1);

        public Time go(int var1, int var2, int var3);

        public Time go(int var1, int var2, int var3, int var4, int var5, int var6);

        public Time days(int var1);

        public Time months(int var1);

        public Time years(int var1);

        public Time nextMinute();

        public Time nextMinutes(int var1);

        public Time nextHour();

        public Time nextHours(int var1);

        public Time nextWeek();

        public Time nextWeeks(int var1);

        public Time nextDay();

        public Time nextDays(int var1);

        public Time nextMonth();

        public Time nextMonths(int var1);

        public Time nextYear();

        public Time nextYears(int var1);

        public void go(int var1);
    }
}

