/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.junit.enhance;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.coodex.concurrent.ExecutableWrapper;
import org.coodex.junit.enhance.TestUtils;

public class ExecutableWrapperImplForJunitEnhance
implements ExecutableWrapper {
    public Runnable wrap(Runnable runnable) {
        Map<String, Object> objectMap = TestUtils.contextClone();
        return objectMap == null ? runnable : () -> {
            TestUtils.CONTEXT.set(objectMap);
            try {
                runnable.run();
            }
            finally {
                TestUtils.CONTEXT.remove();
            }
        };
    }

    public <V> Callable<V> wrap(Callable<V> callable) {
        Map<String, Object> objectMap = TestUtils.contextClone();
        return objectMap == null ? callable : () -> {
            TestUtils.CONTEXT.set(objectMap);
            try {
                Object v = callable.call();
                return v;
            }
            finally {
                TestUtils.CONTEXT.remove();
            }
        };
    }

    public Runnable wrap(Runnable command, long delay, TimeUnit unit) {
        Map<String, Object> objectMap = TestUtils.contextClone();
        return objectMap == null ? command : () -> {
            TestUtils.CONTEXT.set(objectMap);
            try {
                int x = (int)unit.toMillis(delay);
                if (x > 0) {
                    TestUtils.TIME.go(x);
                }
                command.run();
            }
            finally {
                TestUtils.CONTEXT.remove();
            }
        };
    }

    public <V> Callable<V> wrap(Callable<V> callable, long delay, TimeUnit unit) {
        Map<String, Object> objectMap = TestUtils.contextClone();
        return objectMap == null ? callable : () -> {
            TestUtils.CONTEXT.set(objectMap);
            try {
                int x = (int)unit.toMillis(delay);
                if (x > 0) {
                    TestUtils.TIME.go(x);
                }
                Object v = callable.call();
                return v;
            }
            finally {
                TestUtils.CONTEXT.remove();
            }
        };
    }

    public Runnable wrap(final Runnable command, final long initialDelay, final long period, final TimeUnit unit) {
        final Map<String, Object> objectMap = TestUtils.contextClone();
        return objectMap == null ? command : new Runnable(){
            int times = 0;

            @Override
            public void run() {
                TestUtils.CONTEXT.set(objectMap);
                try {
                    int x = (int)(this.times++ == 0 ? unit.toMillis(initialDelay) : unit.toMillis(period));
                    if (x > 0) {
                        TestUtils.TIME.go(x);
                    }
                    command.run();
                }
                finally {
                    TestUtils.CONTEXT.remove();
                }
            }
        };
    }

    public <V> Callable<V> wrap(final Callable<V> callable, final long initialDelay, final long period, final TimeUnit unit) {
        final Map<String, Object> objectMap = TestUtils.contextClone();
        return objectMap == null ? callable : new Callable<V>(){
            int times = 0;

            @Override
            public V call() throws Exception {
                TestUtils.CONTEXT.set(objectMap);
                try {
                    int x = (int)(this.times++ == 0 ? unit.toMillis(initialDelay) : unit.toMillis(period));
                    if (x > 0) {
                        TestUtils.TIME.go(x);
                    }
                    Object v = callable.call();
                    return v;
                }
                finally {
                    TestUtils.CONTEXT.remove();
                }
            }
        };
    }
}

