/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.junit.enhance;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.coodex.junit.enhance.Context;
import org.coodex.junit.enhance.Entry;
import org.coodex.junit.enhance.MapContext;
import org.coodex.junit.enhance.TestUtils;
import org.coodex.util.Clock;
import org.coodex.util.Common;

class MapContextUtil {
    MapContextUtil() {
    }

    static Map<String, Object> buildMapContext(Annotated annotated) {
        Entry entry;
        MapContext mapContext = annotated.getAnnotation(MapContext.class);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (mapContext != null) {
            for (Entry entry2 : mapContext.value()) {
                map.put(entry2.key(), entry2.value());
            }
        }
        if ((entry = annotated.getAnnotation(Entry.class)) != null) {
            map.put(entry.key(), entry.value());
        }
        return map;
    }

    static void appendContext(Map<String, Object> context, Annotated annotated, Supplier<String> defaultNameSupplier) {
        Context.Data contextData = Context.Data.from(annotated.getAnnotation(Context.class));
        context.put(TestUtils.KEY_NAME, Common.isBlank((String)contextData.name) ? defaultNameSupplier.get() : contextData.name);
        try {
            context.put(TestUtils.KEY_TIMESTAMP, Common.isBlank((String)contextData.timestamp) ? Clock.getCalendar() : Common.strToCalendar((String)contextData.timestamp, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        catch (Throwable th) {
            System.err.println("invalid timestamp: " + contextData.timestamp);
            context.put(TestUtils.KEY_TIMESTAMP, Clock.getCalendar());
        }
    }

    static interface Annotated {
        public <A extends Annotation> A getAnnotation(Class<A> var1);
    }
}

