/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.junit.enhance;

import java.util.HashMap;
import java.util.Map;
import org.coodex.junit.enhance.ContextProvider4JUnit4;
import org.coodex.junit.enhance.Entry;
import org.coodex.junit.enhance.MapContext;
import org.coodex.junit.enhance.MapContextUtil;
import org.coodex.junit.enhance.TestUtils;
import org.coodex.util.LazySelectableServiceLoader;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class CoodexEnhanceTestRule
implements TestRule {
    private static final LazySelectableServiceLoader<Description, ContextProvider4JUnit4> CONTEXT_PROVIDER_LOADER = new LazySelectableServiceLoader<Description, ContextProvider4JUnit4>(new ContextProvider4JUnit4(){

        @Override
        public Map<String, Object> createContext(Description description) {
            return MapContextUtil.buildMapContext(arg_0 -> ((Description)description).getAnnotation(arg_0));
        }

        public boolean accept(Description param) {
            return param.getAnnotation(MapContext.class) != null || param.getAnnotation(Entry.class) != null;
        }
    }){};

    public Statement apply(final Statement statement, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                if (TestUtils.CONTEXT.get() != null) {
                    statement.evaluate();
                } else {
                    TestUtils.CONTEXT.set(CoodexEnhanceTestRule.buildContext(description));
                    try {
                        statement.evaluate();
                    }
                    finally {
                        TestUtils.CONTEXT.remove();
                    }
                }
            }
        };
    }

    private static Map<String, Object> buildContext(Description description) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        CONTEXT_PROVIDER_LOADER.selectAll((Object)description).forEach(contextProvider4JUnit4 -> map.putAll(contextProvider4JUnit4.createContext(description)));
        MapContextUtil.appendContext(map, arg_0 -> ((Description)description).getAnnotation(arg_0), () -> ((Description)description).getMethodName());
        return map;
    }
}

