/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.junit.enhance;

import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.coodex.config.Config;
import org.coodex.junit.enhance.AbstractLoggerProvider;
import org.coodex.util.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log4j2LoggerProvider
extends AbstractLoggerProvider {
    private static final Singleton<String> CONSOLE_APPENDER_KEY = Singleton.with(() -> (String)Config.getValue((String)"logger.appender.console", (Object)"Console", (String[])new String[0]));

    protected String getFileAppenderDefaultPattern() {
        return "%d{HH:mm:ss.SSS} [%t] %-5level %logger{36} - %msg%n";
    }

    protected String getDefaultPath() {
        return "logs/";
    }

    private Logger newLogger(String loggerName) {
        LoggerContext ctx = LoggerContext.getContext((boolean)false);
        Configuration configuration = ctx.getConfiguration();
        this.newAppender(loggerName, configuration);
        this.newLoggerConfig(loggerName, configuration);
        ctx.updateLoggers();
        return LoggerFactory.getLogger((String)loggerName);
    }

    private void buildConsoleAppender(Configuration configuration) {
        ConsoleAppender appender = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setName((String)CONSOLE_APPENDER_KEY.get())).setLayout((Layout)PatternLayout.newBuilder().withCharset(StandardCharsets.UTF_8).withPattern((String)Config.getValue((String)"logger.console.pattern", (Object)"%d{HH:mm:ss.SSS} [%t] %-5level %logger{36} - %msg%n", (String[])new String[0])).withConfiguration(configuration).build())).setTarget(ConsoleAppender.Target.SYSTEM_OUT).setImmediateFlush(true)).setConfiguration(configuration)).build();
        appender.start();
        configuration.addAppender((Appender)appender);
    }

    private void newLoggerConfig(String loggerName, Configuration configuration) {
        AppenderRef[] appenderRefArray;
        Level level = Level.toLevel((String)((String)Config.getValue((String)("logger." + loggerName + ".level"), () -> Config.get((String)"logger.level", (String[])new String[0]), (String[])new String[0])), (Level)Level.INFO);
        boolean console = (Boolean)Config.getValue((String)"logger.console", (Object)true, (String[])new String[0]);
        if (console && configuration.getAppender((String)CONSOLE_APPENDER_KEY.get()) == null) {
            this.buildConsoleAppender(configuration);
        }
        LoggerConfig.Builder builder = LoggerConfig.newBuilder().withAdditivity(false).withLevel(level).withLoggerName(loggerName);
        if (console) {
            AppenderRef[] appenderRefArray2 = new AppenderRef[2];
            appenderRefArray2[0] = AppenderRef.createAppenderRef((String)loggerName, (Level)level, null);
            appenderRefArray = appenderRefArray2;
            appenderRefArray2[1] = AppenderRef.createAppenderRef((String)((String)CONSOLE_APPENDER_KEY.get()), (Level)level, null);
        } else {
            AppenderRef[] appenderRefArray3 = new AppenderRef[1];
            appenderRefArray = appenderRefArray3;
            appenderRefArray3[0] = AppenderRef.createAppenderRef((String)loggerName, (Level)level, null);
        }
        LoggerConfig loggerConfig = builder.withRefs(appenderRefArray).withConfig(configuration).build();
        loggerConfig.addAppender(configuration.getAppender(loggerName), level, null);
        if (console) {
            loggerConfig.addAppender(configuration.getAppender((String)CONSOLE_APPENDER_KEY.get()), level, null);
        }
        configuration.addLogger(loggerName, loggerConfig);
    }

    private void newAppender(String loggerName, Configuration configuration) {
        FileAppender appender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().setConfiguration(configuration)).setName(loggerName)).setLayout((Layout)PatternLayout.newBuilder().withCharset(StandardCharsets.UTF_8).withPattern((String)Config.getValue((String)("logger." + loggerName + ".pattern"), (Object)((String)Config.getValue((String)"logger.pattern", (Object)this.getFileAppenderDefaultPattern(), (String[])new String[0])), (String[])new String[0])).build())).withAppend(false).withFileName((String)Config.getValue((String)"logger.path", (Object)this.getDefaultPath(), (String[])new String[0]) + loggerName + ".log").build();
        appender.start();
        configuration.addAppender((Appender)appender);
    }

    @Override
    protected Logger build(String name) {
        return this.newLogger(name);
    }
}

