/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.mock;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.InvocationHandler;
import org.coodex.closure.CallableClosure;
import org.coodex.closure.MapClosureContext;
import org.coodex.closure.StackClosureContext;
import org.coodex.mock.BooleanTypeMocker;
import org.coodex.mock.CharTypeMocker;
import org.coodex.mock.Mock;
import org.coodex.mock.MockException;
import org.coodex.mock.MockerProvider;
import org.coodex.mock.NumberTypeMocker;
import org.coodex.mock.RelationStrategy;
import org.coodex.mock.SequenceMocker;
import org.coodex.mock.SequenceMockerFactory;
import org.coodex.mock.StringTypeMocker;
import org.coodex.mock.TypeMocker;
import org.coodex.util.ClassNameFilter;
import org.coodex.util.Common;
import org.coodex.util.GenericTypeHelper;
import org.coodex.util.PojoInfo;
import org.coodex.util.PojoProperty;
import org.coodex.util.ReflectHelper;
import org.coodex.util.ServiceLoader;
import org.coodex.util.ServiceLoaderImpl;
import org.coodex.util.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoodexMockerProvider
implements MockerProvider {
    private static final Logger log = LoggerFactory.getLogger(CoodexMockerProvider.class);
    private static StackClosureContext<Type> TYPE_CONTEXT = new StackClosureContext();
    private static MapClosureContext<String, List<Annotation>> MOCKER_DEFINITION_CONTEXT = new MapClosureContext<String, List<Annotation>>(){

        public Object call(Map<String, List<Annotation>> map, CallableClosure callableClosure) throws Throwable {
            Map contextMap = (Map)super.get();
            HashMap<String, List<Annotation>> copy = new HashMap<String, List<Annotation>>(map);
            if (contextMap != null) {
                for (Map.Entry<String, List<Annotation>> entry : map.entrySet()) {
                    if (!contextMap.containsKey(entry.getKey())) continue;
                    entry.getValue().addAll((Collection)contextMap.get(entry.getKey()));
                }
            }
            return super.call(copy, callableClosure);
        }
    };
    private static MapClosureContext<String, SequenceMockerFactory> SEQUENCE_MOCKER_CONTEXT = new MapClosureContext();
    private static StackClosureContext<Map<String, SequenceMocker>> COLLECTION_CONTEXT = new StackClosureContext();
    private static StackClosureContext<CollectionDimensions> DIMENSIONS_CONTEXT = new StackClosureContext();
    private static MapClosureContext<Class, TypeAssignation> POJO_ASSIGNATION_CONTEXT = new MapClosureContext();
    private static PojoDeepStackContext POJO_DEEP_CONTEXT = new PojoDeepStackContext();
    private static ServiceLoader<SequenceMockerFactory> SEQUENCE_MOCKER_FACTORIES = new ServiceLoaderImpl<SequenceMockerFactory>(){};
    private static Object INJECT_UNENFORCED = new Object();
    private static Object STRATEGY_UNENFORCED = new Object();
    private static Object STRATEGY_RETRY = new Object();
    private static Singleton<Collection<TypeMocker>> TYPE_MOCKERS = new Singleton((Singleton.Builder)new Singleton.Builder<Collection<TypeMocker>>(){

        public Collection<TypeMocker> build() {
            return new ServiceLoaderImpl<TypeMocker>(){}.getAll().values();
        }
    });
    private static Object NOT_COLLECTION = new Object();
    private static Map<Class, TypeAssignation> GLOBAL_ASSIGNATION = null;
    private static ServiceLoader<RelationStrategy> RELATION_STRATEGIES = new ServiceLoaderImpl<RelationStrategy>(){};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoodexMockerProvider() {
        if (GLOBAL_ASSIGNATION != null) return;
        Class<CoodexMockerProvider> clazz = CoodexMockerProvider.class;
        synchronized (CoodexMockerProvider.class) {
            if (GLOBAL_ASSIGNATION != null) return;
            GLOBAL_ASSIGNATION = new HashMap<Class, TypeAssignation>();
            ReflectHelper.foreachClass((ReflectHelper.Processor)new ReflectHelper.Processor(){

                public void process(Class<?> serviceClass) {
                    GLOBAL_ASSIGNATION.put(serviceClass.getAnnotation(Mock.Assignation.class).value(), new TypeAssignation(new PojoInfo(serviceClass)));
                }
            }, (ClassNameFilter)new ClassNameFilter(){

                public boolean accept(String className) {
                    try {
                        Class<?> c = Class.forName(className);
                        return c.getAnnotation(Mock.Assignation.class) != null;
                    }
                    catch (Throwable throwable) {
                        log.debug("class {} load failed. {}", (Object)className, (Object)throwable.getLocalizedMessage());
                        return false;
                    }
                }
            }, (String[])new String[]{"mock.assign"});
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static List<Annotation> getAllDecoratedBy(Class<? extends Annotation> decorator, Annotation ... annotations) {
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        if (annotations != null && annotations.length > 0) {
            for (Annotation annotation : annotations) {
                if (annotation.annotationType().getAnnotation(decorator) == null) continue;
                list.add(annotation);
            }
        }
        return list;
    }

    private static List<Annotation> getMockers(Annotation ... annotations) {
        return CoodexMockerProvider.getAllDecoratedBy(Mock.class, annotations);
    }

    private static Object runCallable(CallableClosure callableClosure) {
        try {
            return callableClosure.call();
        }
        catch (Throwable throwable) {
            if (throwable instanceof MockException) {
                throw (MockException)throwable;
            }
            throw new MockException(throwable.getLocalizedMessage(), throwable);
        }
    }

    private static <A extends Annotation> A getAnnotation(Class<A> annotationClass, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(annotationClass)) continue;
            return (A)annotation;
        }
        return null;
    }

    private static MockFacade getTypeMocker(Type type, List<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            if (annotation != null && annotation.annotationType().getAnnotation(Mock.class) == null) continue;
            for (TypeMocker provider : (Collection)TYPE_MOCKERS.get()) {
                if (annotation != null && !annotation.annotationType().equals(GenericTypeHelper.solveFromType(TypeMocker.class.getTypeParameters()[0], provider.getClass())) || !provider.accept(annotation, type)) continue;
                return new MockFacade(type, provider, annotation, CoodexMockerProvider.getAnnotation(Mock.Nullable.class, annotations.toArray(new Annotation[0])));
            }
        }
        return null;
    }

    private static Map<Class, TypeAssignation> getTypeAssignationsFromAnnotations(Annotation[] annotations) throws InvocationTargetException, IllegalAccessException {
        HashMap<Class, TypeAssignation> map = new HashMap<Class, TypeAssignation>();
        for (Annotation annotation : CoodexMockerProvider.getAllDecoratedBy(Mock.Assignation.class, annotations)) {
            map.put(annotation.annotationType().getAnnotation(Mock.Assignation.class).value(), new TypeAssignation(annotation));
        }
        return map;
    }

    private Object mockParameterizedType(ParameterizedType type, Annotation ... annotations) throws InvocationTargetException, IllegalAccessException {
        Class c = (Class)type.getRawType();
        Object result = this.mockIfCollectionAndMap(c, type, annotations);
        if (result != NOT_COLLECTION) {
            return result;
        }
        return this.mockPojo(type, annotations);
    }

    private Object mockClass(Class c, Annotation ... annotations) throws InvocationTargetException, IllegalAccessException {
        Object result = this.mockIfInject(c, InjectConfig.build(CoodexMockerProvider.getAnnotation(Mock.Inject.class, annotations)), annotations);
        if (result != INJECT_UNENFORCED) {
            return result;
        }
        MockFacade param = CoodexMockerProvider.getTypeMocker(c, CoodexMockerProvider.getMockers(annotations));
        if (param != null) {
            return param.mock();
        }
        if (String.class.equals((Object)c)) {
            return StringTypeMocker.mock();
        }
        if (Common.inArray((Object)c, (Object[])NumberTypeMocker.SUPPORTED)) {
            return NumberTypeMocker.mock(c);
        }
        if (Common.inArray((Object)c, (Object[])CharTypeMocker.SUPPORTED_CLASSES)) {
            return CharTypeMocker.mock(c);
        }
        if (Common.inArray((Object)c, (Object[])BooleanTypeMocker.SUPPORTED)) {
            return BooleanTypeMocker.mock(c);
        }
        Object object = result = c.isArray() ? this.mockArray(c.getComponentType(), 0, annotations) : this.mockIfCollectionAndMap(c, c, annotations);
        if (result != NOT_COLLECTION) {
            return result;
        }
        return this.mockPojo(c, annotations);
    }

    private Object mockIfCollectionAndMap(Class c, Type collectionsContext, Annotation[] annotations) {
        Object result;
        if (Collection.class.isAssignableFrom(c)) {
            Type t = GenericTypeHelper.solveFromType(Collection.class.getTypeParameters()[0], (Type)collectionsContext);
            if (t instanceof TypeVariable) {
                throw new MockException("Cannot mock collection: " + collectionsContext);
            }
            result = this.mockCollection(c, t, 0, annotations);
        } else if (Map.class.isAssignableFrom(c)) {
            Type key = GenericTypeHelper.solveFromType(Map.class.getTypeParameters()[0], (Type)collectionsContext);
            Type value = GenericTypeHelper.solveFromType(Map.class.getTypeParameters()[1], (Type)collectionsContext);
            if (key instanceof TypeVariable || value instanceof TypeVariable) {
                throw new MockException("Cannot mock map: " + collectionsContext);
            }
            result = this.mockMap(c, 0, key, value, annotations);
        } else {
            result = NOT_COLLECTION;
        }
        return result;
    }

    private Object mockPojo(final Type type, final Annotation ... annotations) throws InvocationTargetException, IllegalAccessException {
        CallableClosure closure = new CallableClosure(){

            public Object call() {
                return POJO_DEEP_CONTEXT.useRTE(type, new CallableClosure(){

                    public Object call() throws Throwable {
                        Object instance;
                        PojoInfo pojoInfo = new PojoInfo(type);
                        TypeAssignation current = new TypeAssignation(pojoInfo);
                        TypeAssignation typeAssignation = (TypeAssignation)POJO_ASSIGNATION_CONTEXT.get((Object)GenericTypeHelper.typeToClass((Type)type));
                        TypeAssignation typeAssignation2 = typeAssignation = typeAssignation == null ? current : typeAssignation.merge(current);
                        if (this.depthCheck(current, typeAssignation)) {
                            return null;
                        }
                        HashMap<String, Object> mocked = new HashMap<String, Object>();
                        List<PojoProperty> properties = this.getPojoPropertiesAndSort(pojoInfo);
                        while (properties.size() > 0) {
                            ArrayList<PojoProperty> temp = new ArrayList<PojoProperty>();
                            for (PojoProperty pojoProperty : properties) {
                                Annotation[] mockAnnotations = typeAssignation.get(pojoProperty.getName());
                                Mock.Relation relation = (Mock.Relation)CoodexMockerProvider.getAnnotation(Mock.Relation.class, mockAnnotations);
                                if (relation == null) {
                                    mocked.put(pojoProperty.getName(), CoodexMockerProvider.this.mock(GenericTypeHelper.toReference((Type)pojoProperty.getType(), (Type)type), type, typeAssignation.get(pojoProperty.getName())));
                                    temp.add(pojoProperty);
                                    continue;
                                }
                                RelationStrategy toUse = null;
                                for (RelationStrategy strategy : RELATION_STRATEGIES.getAll().values()) {
                                    if (!strategy.accept(relation.strategy())) continue;
                                    toUse = strategy;
                                    break;
                                }
                                if (toUse == null) {
                                    throw new MockException("none RelationStrategy accept [" + relation.strategy() + "]. " + relation.toString());
                                }
                                if (!this.isAllMocked(relation, mocked, typeAssignation)) continue;
                                Object result = this.relationCall(mocked, relation, toUse);
                                if (relation == STRATEGY_UNENFORCED) {
                                    throw new MockException("strategy unenforced. " + toUse);
                                }
                                if (relation == STRATEGY_RETRY) continue;
                                mocked.put(pojoProperty.getName(), result);
                                temp.add(pojoProperty);
                            }
                            if (temp.size() == 0) {
                                StringBuilder builder = new StringBuilder();
                                builder.append("invalid dependency. ");
                                for (PojoProperty property : properties) {
                                    builder.append("\n\t").append(property.getAnnotation(Mock.Relation.class));
                                }
                                throw new MockException(builder.toString());
                            }
                            properties.removeAll(temp);
                        }
                        MockInvocationHandler mockInvocationHandler = new MockInvocationHandler(mocked);
                        if (pojoInfo.getRowType().isInterface()) {
                            instance = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{pojoInfo.getRowType()}, (java.lang.reflect.InvocationHandler)mockInvocationHandler);
                        } else {
                            Enhancer enhancer = new Enhancer();
                            enhancer.setSuperclass(pojoInfo.getRowType());
                            enhancer.setCallback((Callback)mockInvocationHandler);
                            try {
                                instance = enhancer.create();
                            }
                            catch (IllegalArgumentException e) {
                                throw new MockException("mock " + pojoInfo.getRowType().getName() + " failed: " + e.getLocalizedMessage(), (Throwable)e);
                            }
                            for (Field field : instance.getClass().getFields()) {
                                if (!mocked.containsKey(field.getName())) continue;
                                field.setAccessible(true);
                                field.set(instance, mocked.get(field.getName()));
                            }
                            try {
                                instance = JSON.parseObject((String)JSON.toJSONString((Object)instance), (Type)pojoInfo.getType(), (Feature[])new Feature[0]);
                            }
                            catch (Throwable th) {
                                log.warn("convert failed. {}, {}, {}", new Object[]{th.getLocalizedMessage(), pojoInfo.getType(), JSON.toJSONString((Object)instance)});
                            }
                        }
                        return instance;
                    }

                    private Object relationCall(Map<String, Object> mocked, Mock.Relation relation, RelationStrategy toUse) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
                        Object result = STRATEGY_UNENFORCED;
                        for (Method method : toUse.getClass().getDeclaredMethods()) {
                            RelationStrategy.Strategy strategy = method.getAnnotation(RelationStrategy.Strategy.class);
                            if (strategy == null || !strategy.value().equals(relation.strategy())) continue;
                            Object[] args = new Object[relation.dependencies().length];
                            int i = 0;
                            int len = method.getParameterTypes().length;
                            while (i < len) {
                                String methodName = ReflectHelper.getParameterName((Method)method, (int)i);
                                if (!Common.inArray((Object)methodName, (Object[])relation.dependencies())) {
                                    throw new MockException("relation " + relation + " not included " + methodName + ". " + method.toGenericString());
                                }
                                if (!mocked.containsKey(methodName)) {
                                    result = STRATEGY_RETRY;
                                    break;
                                }
                                args[i++] = mocked.get(methodName);
                            }
                            if (result == STRATEGY_RETRY) break;
                            result = method.invoke((Object)toUse, args);
                            break;
                        }
                        return result;
                    }

                    private boolean isAllMocked(Mock.Relation relation, Map<String, Object> mocked, TypeAssignation assignation) {
                        for (String dependency : relation.dependencies()) {
                            if (!assignation.properties.containsKey(dependency) || mocked.containsKey(dependency)) continue;
                            return false;
                        }
                        return true;
                    }

                    private List<PojoProperty> getPojoPropertiesAndSort(PojoInfo pojoInfo) {
                        ArrayList<PojoProperty> properties = new ArrayList<PojoProperty>(pojoInfo.getProperties());
                        Collections.sort(properties, new Comparator<PojoProperty>(){
                            int[] range = new int[]{0, -1, 1, 0};

                            @Override
                            public int compare(PojoProperty o1, PojoProperty o2) {
                                int b1 = o1.getAnnotation(Mock.Relation.class) == null ? 0 : 2;
                                int b2 = o2.getAnnotation(Mock.Relation.class) == null ? 0 : 1;
                                return this.range[b1 | b2];
                            }
                        });
                        return properties;
                    }

                    private boolean depthCheck(TypeAssignation current, TypeAssignation typeAssignation) {
                        int maxDepth = 3;
                        Mock.Depth depth = (Mock.Depth)CoodexMockerProvider.getAnnotation(Mock.Depth.class, annotations);
                        if (depth == null) {
                            depth = current.depth;
                        }
                        if (depth == null) {
                            depth = typeAssignation.depth;
                        }
                        if (depth != null) {
                            maxDepth = Math.max(depth.value(), 1);
                        }
                        return maxDepth < POJO_DEEP_CONTEXT.depth(type);
                    }
                });
            }
        };
        HashMap<Class, TypeAssignation> assignations = POJO_ASSIGNATION_CONTEXT.get() == null ? GLOBAL_ASSIGNATION : new HashMap<Class, TypeAssignation>();
        assignations.putAll(CoodexMockerProvider.getTypeAssignationsFromAnnotations(annotations));
        if (assignations.size() > 0) {
            return POJO_ASSIGNATION_CONTEXT.useRTE(assignations, closure);
        }
        return CoodexMockerProvider.runCallable(closure);
    }

    private Object mockIfInject(Type type, InjectConfig inject, Annotation[] annotations) {
        if (inject != null) {
            MockFacade facade;
            SequenceMockerFactory sequenceMockerFactory;
            if (COLLECTION_CONTEXT.get() != null && (sequenceMockerFactory = (SequenceMockerFactory)SEQUENCE_MOCKER_CONTEXT.get((Object)inject.getKey())) != null && this.acceptType(sequenceMockerFactory, type)) {
                SequenceMocker sequenceMocker = (SequenceMocker)((Map)COLLECTION_CONTEXT.get()).get(inject.getKey());
                if (sequenceMocker == null) {
                    sequenceMocker = sequenceMockerFactory.newSequenceMocker(annotations);
                    ((Map)COLLECTION_CONTEXT.get()).put(inject.getKey(), sequenceMocker);
                }
                return sequenceMocker.next();
            }
            List mockerDefinitions = (List)MOCKER_DEFINITION_CONTEXT.get((Object)inject.getKey());
            if (mockerDefinitions != null && (facade = CoodexMockerProvider.getTypeMocker(type, mockerDefinitions)) != null) {
                return facade.mock();
            }
            MockException mockException = new MockException("Mocker not found. key:" + inject.getKey() + "; context: " + TYPE_CONTEXT.get());
            switch (inject.getNotFound()) {
                case WARN: {
                    log.warn(mockException.getLocalizedMessage());
                    break;
                }
                case ERROR: {
                    throw mockException;
                }
            }
        }
        return INJECT_UNENFORCED;
    }

    private boolean acceptType(SequenceMockerFactory sequenceMockerFactory, Type type) {
        Class c1 = GenericTypeHelper.typeToClass((Type)GenericTypeHelper.solveFromInstance(SequenceMockerFactory.class.getTypeParameters()[0], (Object)sequenceMockerFactory));
        Class c2 = GenericTypeHelper.typeToClass((Type)type);
        return c1.isAssignableFrom(c2);
    }

    public <T> T mock(Class<T> type, Annotation ... annotations) {
        return (T)this.mock(type, type, annotations);
    }

    public Object mock(final Type type, final Type context, Annotation ... annotations) {
        if (annotations == null) {
            annotations = new Annotation[]{};
        }
        final Annotation[] finalAnnotations = annotations;
        return TYPE_CONTEXT.useRTE((Object)context, new CallableClosure(){

            public Object call() {
                return CoodexMockerProvider.this.innerMock(GenericTypeHelper.toReference((Type)type, (Type)context), finalAnnotations);
            }
        });
    }

    private Object mockArray(Type componentType, int d, Annotation ... annotations) {
        List list = this.mockCollection(List.class, componentType, d, annotations);
        if (list != null) {
            Object arrayInstance = Array.newInstance(GenericTypeHelper.typeToClass((Type)componentType), list.size());
            int i = 0;
            for (Object o : list) {
                Array.set(arrayInstance, i++, o);
            }
            return arrayInstance;
        }
        return null;
    }

    private Map buildMapInstance(Class mapClass, int d, Annotation ... annotations) {
        if (Map.class.equals((Object)mapClass)) {
            return ((CollectionDimensions)DIMENSIONS_CONTEXT.get()).ordered(d) ? new LinkedHashMap() : new HashMap();
        }
        try {
            if (mapClass.isInterface()) {
                return (Map)this.getProxyObject(((CollectionDimensions)DIMENSIONS_CONTEXT.get()).ordered(d) ? new LinkedHashMap() : new HashMap(), mapClass);
            }
            Constructor constructor = mapClass.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (Map)constructor.newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            throw new MockException("map class " + mapClass.getName() + " not support yet.", throwable);
        }
    }

    private Collection buildCollectionInstance(Class collectionClass, int d, Annotation ... annotations) {
        Collection x = this.getJavaUtilCollection(collectionClass, d);
        if (x != null) {
            return x;
        }
        try {
            if (collectionClass.isInterface()) {
                return (Collection)this.getProxyObject(this.getJavaUtilCollection(Collection.class, d), collectionClass);
            }
            Constructor constructor = collectionClass.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (Collection)constructor.newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            throw new MockException("collection class " + collectionClass.getName() + " not support yet. ", throwable);
        }
    }

    private Collection getJavaUtilCollection(Class collectionClass, int d) {
        if (List.class.equals((Object)collectionClass)) {
            return new ArrayList();
        }
        if (Set.class.equals((Object)collectionClass)) {
            return ((CollectionDimensions)DIMENSIONS_CONTEXT.get()).ordered(d) ? new LinkedHashSet() : new HashSet();
        }
        if (Collection.class.equals((Object)collectionClass)) {
            return ((CollectionDimensions)DIMENSIONS_CONTEXT.get()).ordered(d) ? new ArrayList() : new HashSet();
        }
        return null;
    }

    private Object getProxyObject(final Object instance, Class interfaceClass) {
        return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{interfaceClass}, new java.lang.reflect.InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
                Method targetMethod = instance.getClass().getMethod(method.getName(), method.getParameterTypes());
                targetMethod.setAccessible(true);
                return targetMethod.invoke(instance, args);
            }
        });
    }

    private <C extends Collection> C mockCollection(final Class<C> collectionClass, final Type componentType, final int d, final Annotation ... annotations) {
        CallableClosure closure = new CallableClosure(){

            private Object mockElementOfCollection() {
                Class c;
                Object result = CoodexMockerProvider.this.mockIfInject(componentType, InjectConfig.build((Mock.Inject)CoodexMockerProvider.getAnnotation(Mock.Inject.class, annotations)), annotations);
                if (result != INJECT_UNENFORCED) {
                    return result;
                }
                MockFacade param = CoodexMockerProvider.getTypeMocker(componentType, CoodexMockerProvider.getMockers(annotations));
                if (param != null) {
                    return param.mock();
                }
                if (componentType instanceof GenericArrayType) {
                    return CoodexMockerProvider.this.mockArray(((GenericArrayType)componentType).getGenericComponentType(), d + 1, annotations);
                }
                if (componentType instanceof Class && (c = (Class)componentType).isArray()) {
                    return CoodexMockerProvider.this.mockArray(c.getComponentType(), d + 1, annotations);
                }
                if (componentType instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)componentType;
                    Class c2 = GenericTypeHelper.typeToClass((Type)parameterizedType.getRawType());
                    if (Collection.class.isAssignableFrom(c2)) {
                        return CoodexMockerProvider.this.mockCollection(c2, GenericTypeHelper.solveFromType(Collection.class.getTypeParameters()[0], (Type)parameterizedType), d + 1, annotations);
                    }
                    if (Map.class.isAssignableFrom(c2)) {
                        return CoodexMockerProvider.this.mockMap(c2, d + 1, GenericTypeHelper.solveFromType(Map.class.getTypeParameters()[0], (Type)componentType), GenericTypeHelper.solveFromType(Map.class.getTypeParameters()[1], (Type)componentType), annotations);
                    }
                }
                return CoodexMockerProvider.this.innerMock(componentType, annotations);
            }

            public Object call() {
                if (((CollectionDimensions)DIMENSIONS_CONTEXT.get()).nullable(d)) {
                    return null;
                }
                Collection collection = CoodexMockerProvider.this.buildCollectionInstance(collectionClass, d, annotations);
                CollectionDimensions dimensions = (CollectionDimensions)DIMENSIONS_CONTEXT.get();
                int size = dimensions.getSize(d);
                for (int i = 0; i < size; ++i) {
                    collection.add(this.mockElementOfCollection());
                }
                return collection;
            }
        };
        return (C)((Collection)CoodexMockerProvider.runCallable(this.getDimensionsClosure(d, this.getCollectionSequenceClosure(closure), annotations)));
    }

    private CallableClosure getCollectionSequenceClosure(final CallableClosure callableClosure) {
        return new CallableClosure(){

            public Object call() throws Throwable {
                return COLLECTION_CONTEXT.call(new HashMap(), callableClosure);
            }
        };
    }

    private CallableClosure getDimensionsClosure(int d, CallableClosure closure, Annotation[] annotations) {
        if (d == 0) {
            CollectionDimensions collectionDimensions;
            final CallableClosure callableClosure = closure;
            Mock.Dimensions dimensionsAnnotation = CoodexMockerProvider.getAnnotation(Mock.Dimensions.class, annotations);
            if (dimensionsAnnotation != null) {
                collectionDimensions = new CollectionDimensions(dimensionsAnnotation.value(), dimensionsAnnotation.same());
            } else {
                Mock.Dimension[] dimensionArray;
                Mock.Dimension dimension = CoodexMockerProvider.getAnnotation(Mock.Dimension.class, annotations);
                if (dimension == null) {
                    dimensionArray = new Mock.Dimension[]{};
                } else {
                    Mock.Dimension[] dimensionArray2 = new Mock.Dimension[1];
                    dimensionArray = dimensionArray2;
                    dimensionArray2[0] = dimension;
                }
                collectionDimensions = new CollectionDimensions(dimensionArray, true);
            }
            closure = new CallableClosure(){

                public Object call() throws Throwable {
                    return DIMENSIONS_CONTEXT.call((Object)collectionDimensions, callableClosure);
                }
            };
        }
        return closure;
    }

    private Object mockMap(final Class<? extends Map> mapClass, final int d, final Type keyType, final Type valueType, final Annotation ... annotations) {
        CallableClosure closure = new CallableClosure(){

            private Object mockValue() {
                Object value = CoodexMockerProvider.this.mockIfInject(valueType, InjectConfig.build((Mock.Value)CoodexMockerProvider.getAnnotation(Mock.Value.class, annotations)), annotations);
                return value == INJECT_UNENFORCED ? CoodexMockerProvider.this.innerMock(valueType, annotations) : value;
            }

            private Object mockKey() {
                Object keyMock = CoodexMockerProvider.this.mockIfInject(keyType, InjectConfig.build((Mock.Key)CoodexMockerProvider.getAnnotation(Mock.Key.class, annotations)), annotations);
                return keyMock == INJECT_UNENFORCED ? CoodexMockerProvider.this.innerMock(keyType, annotations) : keyMock;
            }

            public Object call() {
                if (((CollectionDimensions)DIMENSIONS_CONTEXT.get()).nullable(d)) {
                    return null;
                }
                Map instance = CoodexMockerProvider.this.buildMapInstance(mapClass, d, annotations);
                int size = ((CollectionDimensions)DIMENSIONS_CONTEXT.get()).getSize(d);
                int retry = size * 3;
                while (instance.size() < size && retry-- > 0) {
                    instance.put(this.mockKey(), this.mockValue());
                }
                return instance;
            }
        };
        return CoodexMockerProvider.runCallable(this.getDimensionsClosure(d, this.getCollectionSequenceClosure(closure), annotations));
    }

    private Object innerMock(final Type type, final Annotation ... annotations) {
        if (type == null || Void.TYPE.equals(type) || Void.class.equals((Object)type)) {
            return null;
        }
        Mock.Designated designated = CoodexMockerProvider.getAnnotation(Mock.Designated.class, annotations);
        if (designated != null) {
            // empty if block
        }
        CallableClosure closure = new CallableClosure(){

            public Object call() throws InvocationTargetException, IllegalAccessException {
                Type toMock = type;
                if (toMock instanceof TypeVariable) {
                    toMock = GenericTypeHelper.solveFromType((TypeVariable)((TypeVariable)toMock), (Type)((Type)TYPE_CONTEXT.get()));
                }
                if (toMock instanceof TypeVariable) {
                    throw new MockException("TypeVariable " + toMock + " not supported.");
                }
                if (toMock instanceof Class) {
                    return CoodexMockerProvider.this.mockClass((Class)toMock, annotations);
                }
                if (toMock instanceof ParameterizedType) {
                    return CoodexMockerProvider.this.mockParameterizedType((ParameterizedType)toMock, annotations);
                }
                if (toMock instanceof GenericArrayType) {
                    return CoodexMockerProvider.this.mockArray(((GenericArrayType)toMock).getGenericComponentType(), 0, annotations);
                }
                throw new MockException("unsupported type : " + toMock);
            }
        };
        closure = this.getDefinitionClosure(closure, annotations);
        closure = this.getSequenceClosure(closure, annotations);
        return CoodexMockerProvider.runCallable(closure);
    }

    private CallableClosure getSequenceClosure(CallableClosure closure, Annotation[] annotations) {
        final HashMap<String, SequenceMockerFactory> sequenceMockerMap = new HashMap<String, SequenceMockerFactory>();
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(Mock.Sequence.class)) continue;
            Mock.Sequence sequence = (Mock.Sequence)annotation;
            Class factoryClass = sequence.factory();
            if (!factoryClass.isInterface()) {
                log.warn("{} not interface.", (Object)sequence);
            }
            sequenceMockerMap.put(sequence.name(), this.getSequenceMockerFactory(factoryClass));
        }
        if (sequenceMockerMap.size() > 0) {
            final CallableClosure callableClosure = closure;
            closure = new CallableClosure(){

                public Object call() throws Throwable {
                    return SEQUENCE_MOCKER_CONTEXT.call(sequenceMockerMap, callableClosure);
                }
            };
        }
        return closure;
    }

    private SequenceMockerFactory getSequenceMockerFactory(Class<? extends SequenceMockerFactory> factoryClass) {
        SequenceMockerFactory factory = (SequenceMockerFactory)SEQUENCE_MOCKER_FACTORIES.get(factoryClass);
        if (factory == null && !factoryClass.isInterface()) {
            try {
                factory = factoryClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new MockException(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new MockException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return factory;
    }

    private CallableClosure getDefinitionClosure(CallableClosure closure, Annotation[] annotations) {
        List<Annotation> defList = CoodexMockerProvider.getAllDecoratedBy(Mock.Declaration.class, annotations);
        final HashMap<String, ArrayList<Annotation>> declarationMap = new HashMap<String, ArrayList<Annotation>>();
        for (Annotation annotation : defList) {
            Class<? extends Annotation> c = annotation.annotationType();
            if (c.getName().startsWith("java.") || c.getName().startsWith("javax.")) continue;
            for (Method method : c.getMethods()) {
                String key = method.getName();
                ArrayList<Annotation> mock = new ArrayList<Annotation>(Arrays.asList(method.getDeclaredAnnotations()));
                if (Annotation.class.isAssignableFrom(method.getReturnType())) {
                    method.setAccessible(true);
                    try {
                        mock.add((Annotation)method.invoke((Object)annotation, new Object[0]));
                    }
                    catch (IllegalAccessException e) {
                        throw new MockException("Load @Mock.Declaration failed. " + method.getDeclaringClass() + "." + method.getName(), (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        throw new MockException("Load @Mock.Declaration failed. " + method.getDeclaringClass() + "." + method.getName(), (Throwable)e);
                    }
                }
                if (mock.size() <= 0) continue;
                ArrayList<Annotation> annotationList = (ArrayList<Annotation>)declarationMap.get(key);
                if (annotationList != null) {
                    annotationList.addAll(mock);
                } else {
                    annotationList = mock;
                }
                declarationMap.put(key, annotationList);
            }
        }
        if (declarationMap.size() > 0) {
            final CallableClosure callableClosure = closure;
            closure = new CallableClosure(){

                public Object call() throws Throwable {
                    return MOCKER_DEFINITION_CONTEXT.call(declarationMap, callableClosure);
                }
            };
        }
        return closure;
    }

    class MockInvocationHandler
    implements InvocationHandler,
    java.lang.reflect.InvocationHandler {
        private final Map<String, Object> values;

        MockInvocationHandler(Map<String, Object> values) {
            this.values = values;
        }

        private String getPropertyName(Method method) {
            String name = method.getName();
            if (method.getDeclaringClass().equals(Object.class)) {
                return null;
            }
            if (method.getReturnType().equals(Void.TYPE) || method.getReturnType().equals(Void.class)) {
                return null;
            }
            if (method.getParameterTypes().length > 0) {
                return null;
            }
            if (name.length() > 3 && name.startsWith("get")) {
                return Common.lowerFirstChar((String)name.substring(3));
            }
            if (name.length() > 2 && name.startsWith("is") && method.getReturnType().equals(Boolean.TYPE)) {
                return Common.lowerFirstChar((String)name.substring(2));
            }
            return null;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass().equals(Object.class)) {
                return method.invoke((Object)this, args);
            }
            String propertyName = this.getPropertyName(method);
            if (propertyName == null) {
                throw new MockException("not property getter method." + method.toGenericString());
            }
            return this.values.get(propertyName);
        }
    }

    private static class TypeAssignation {
        private Map<String, Annotation[]> properties = new HashMap<String, Annotation[]>();
        private Mock.Depth depth;

        TypeAssignation(PojoInfo pojoInfo) {
            this.depth = pojoInfo.getRowType().getAnnotation(Mock.Depth.class);
            for (PojoProperty pojoProperty : pojoInfo.getProperties()) {
                this.properties.put(pojoProperty.getName(), pojoProperty.getAnnotations());
            }
        }

        TypeAssignation(Annotation annotation) throws InvocationTargetException, IllegalAccessException {
            this.depth = annotation.annotationType().getAnnotation(Mock.Depth.class);
            ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
            for (Method method : annotation.annotationType().getMethods()) {
                method.setAccessible(true);
                if (method.getReturnType().isAnnotation()) {
                    annotationList.add((Annotation)method.invoke((Object)annotation, new Object[0]));
                }
                annotationList.addAll(Arrays.asList(method.getAnnotations()));
                this.properties.put(method.getName(), annotationList.toArray(new Annotation[0]));
            }
        }

        TypeAssignation merge(TypeAssignation typeAssignation) {
            if (typeAssignation != null) {
                for (Map.Entry<String, Annotation[]> entry : typeAssignation.properties.entrySet()) {
                    if (!this.properties.containsKey(entry.getKey())) {
                        this.properties.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    this.properties.put(entry.getKey(), this.merge(this.properties.get(entry.getKey()), entry.getValue()));
                }
            }
            return this;
        }

        private Annotation[] merge(Annotation[] array1, Annotation[] array2) {
            ArrayList<Annotation> result = new ArrayList<Annotation>(Arrays.asList(array1));
            for (Annotation annotation : array2) {
                if (result.contains(annotation)) continue;
                result.add(annotation);
            }
            return result.toArray(new Annotation[0]);
        }

        int getDepth() {
            return Math.max(1, this.depth == null ? 3 : this.depth.value());
        }

        Annotation[] get(String propertyName) {
            Annotation[] annotations = this.properties.get(propertyName);
            return annotations == null ? new Annotation[]{} : annotations;
        }
    }

    private static class PojoDeepStackContext
    extends StackClosureContext<Type> {
        private PojoDeepStackContext() {
        }

        int depth(Type type) {
            Stack pojoStack = (Stack)super.$getVariant();
            int count = 0;
            for (Type t : pojoStack) {
                if (!t.equals(type)) continue;
                ++count;
            }
            return count;
        }
    }

    private static class InjectConfig {
        private String key;
        private Mock.NotFound notFound;

        InjectConfig(String key, Mock.NotFound notFound) {
            this.key = key;
            this.notFound = notFound;
        }

        static InjectConfig build(Mock.Inject inject) {
            if (inject == null) {
                return null;
            }
            return new InjectConfig(inject.value(), inject.notFound());
        }

        static InjectConfig build(Mock.Key inject) {
            if (inject == null) {
                return null;
            }
            return new InjectConfig(inject.value(), inject.notFound());
        }

        static InjectConfig build(Mock.Value inject) {
            if (inject == null) {
                return null;
            }
            return new InjectConfig(inject.value(), inject.notFound());
        }

        String getKey() {
            return this.key;
        }

        Mock.NotFound getNotFound() {
            return this.notFound;
        }
    }

    private static class CollectionDimensions {
        private Mock.Dimension[] dimensions;
        private int[] corrected;
        private boolean same;

        CollectionDimensions(Mock.Dimension[] dimensions, boolean same) {
            this.dimensions = dimensions;
            this.same = same;
            this.corrected = new int[16];
            Arrays.fill(this.corrected, Integer.MIN_VALUE);
        }

        private int calc(int dimension) {
            int max = 5;
            int min = 1;
            int size = 0;
            if (dimension < this.dimensions.length) {
                Mock.Dimension d = this.dimensions[dimension];
                max = Math.max(1, Math.max(d.max(), d.min()));
                min = Math.max(1, Math.min(d.min(), d.max()));
                size = d.size();
            }
            return size > 0 ? size : new Random().nextInt(max - min + 1) + min;
        }

        int getSize(int dimension) {
            if (dimension >= 16) {
                throw new MockException("too many dimensions.");
            }
            if (this.same) {
                if (this.corrected[dimension] == Integer.MIN_VALUE) {
                    this.corrected[dimension] = this.calc(dimension);
                }
                return this.corrected[dimension];
            }
            return this.calc(dimension);
        }

        boolean nullable(int dimension) {
            if (dimension >= 16) {
                throw new MockException("too many dimensions.");
            }
            if (dimension < this.dimensions.length) {
                return Math.random() < this.dimensions[dimension].nullProbability();
            }
            return false;
        }

        boolean ordered(int dimension) {
            if (dimension >= 16) {
                throw new MockException("too many dimensions.");
            }
            if (dimension >= this.dimensions.length) {
                return true;
            }
            return this.dimensions[dimension].ordered();
        }
    }

    private static class MockFacade {
        private final Type targetType;
        private final TypeMocker mocker;
        private final Annotation annotation;
        private final Mock.Nullable nullable;

        private MockFacade(Type targetType, TypeMocker mocker, Annotation annotation, Mock.Nullable nullable) {
            this.targetType = targetType;
            this.mocker = mocker;
            this.annotation = annotation;
            this.nullable = nullable;
        }

        Object mock() {
            return this.mocker.mock(this.annotation, this.nullable, this.targetType);
        }
    }
}

