/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.mock;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.coodex.mock.AbstractTypeMocker;
import org.coodex.mock.CharTypeMocker;
import org.coodex.mock.Mock;
import org.coodex.util.Common;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringTypeMocker
extends AbstractTypeMocker<Mock.String> {
    private static final Logger log = LoggerFactory.getLogger(StringTypeMocker.class);
    private static Class[] SUPPORTED_CLASSES = new Class[]{String.class};
    private static StringTypeMocker instance;

    public StringTypeMocker() {
        instance = this;
    }

    static String mock() {
        if (instance == null) {
            instance = new StringTypeMocker();
        }
        return (String)instance.mock(null, null, (Type)((Object)String.class));
    }

    @Override
    protected Class[] getSupportedClasses() {
        return SUPPORTED_CLASSES;
    }

    @Override
    protected boolean accept(Mock.String annotation) {
        return true;
    }

    @Override
    public Object mock(Mock.String mockAnnotation, Type targetType) {
        return this.getStringRange(mockAnnotation).random();
    }

    private StringRange getStringRange(Mock.String stringAnnotation) {
        StringRange range = null;
        if (stringAnnotation != null) {
            range = this.loadFromResource(stringAnnotation);
            if (range == null && stringAnnotation.range().length > 0) {
                range = new ArrayStringRange(Arrays.asList(stringAnnotation.range()));
            }
            if (range == null && stringAnnotation.charCodeSets().length > 0) {
                range = new CharRangeBasedStringRange(stringAnnotation.minLength(), stringAnnotation.maxLength(), new CharTypeMocker.CodePointSetCharRange(stringAnnotation.charCodeSets(), false));
            }
        }
        if (range == null) {
            range = new CharRangeBasedStringRange(5, 10, new CharTypeMocker.ArrayCharRange(CharTypeMocker.getRange("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ", false)));
        }
        return range;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringRange loadFromResource(Mock.String stringAnnotation) {
        URL url;
        if (!Common.isBlank((String)stringAnnotation.txtResource()) && (url = Common.getResource((String)stringAnnotation.txtResource(), (ClassLoader[])new ClassLoader[0])) != null) {
            ArrayList<String> stringList = new ArrayList<String>();
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
                try {
                    String line;
                    while ((line = bufferedReader.readLine()) != null) {
                        stringList.add(line);
                    }
                }
                finally {
                    bufferedReader.close();
                }
            }
            catch (Throwable throwable) {
                log.warn("load resource [{}] error: {}", new Object[]{stringAnnotation, throwable.getLocalizedMessage(), throwable});
            }
            if (stringList.size() > 0) {
                return new ArrayStringRange(stringList);
            }
        }
        return null;
    }

    private static class ArrayStringRange
    implements StringRange {
        private List<String> list;

        ArrayStringRange(List<String> strings) {
            this.list = new ArrayList<String>(strings);
        }

        @Override
        public String random() {
            Random random = new Random();
            return this.list.get(random.nextInt(this.list.size()));
        }
    }

    private static class CharRangeBasedStringRange
    implements StringRange {
        final int min;
        final int max;
        final CharTypeMocker.CharRange charRange;

        private CharRangeBasedStringRange(int min, int max, CharTypeMocker.CharRange charRange) {
            this.min = Math.max(1, Math.min(min, max));
            this.max = Math.max(1, Math.max(min, max));
            this.charRange = charRange;
        }

        @Override
        public String random() {
            StringBuilder builder = new StringBuilder();
            int len = new Random().nextInt(this.max - this.min + 1) + this.min;
            for (int i = 0; i <= len; ++i) {
                builder.append(Character.toChars(this.charRange.random()));
            }
            return builder.toString();
        }
    }

    static interface StringRange {
        public String random();
    }
}

