/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.mock.ext;

import java.lang.reflect.Type;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import org.coodex.mock.AbstractTypeMocker;
import org.coodex.mock.ext.DateTime;
import org.coodex.util.Clock;
import org.coodex.util.Common;
import org.coodex.util.GenericTypeHelper;

public class DateTimeTypeMocker
extends AbstractTypeMocker<DateTime> {
    @Override
    protected Class[] getSupportedClasses() {
        return new Class[]{Calendar.class, Date.class, String.class};
    }

    @Override
    protected boolean accept(DateTime annotation) {
        return annotation != null;
    }

    @Override
    public Object mock(DateTime mockAnnotation, Type targetType) {
        Class clazz = GenericTypeHelper.typeToClass((Type)targetType);
        try {
            long dateTime;
            DateFormat format = Common.getSafetyDateFormat((String)mockAnnotation.format());
            long min = 0L;
            long max = Long.MAX_VALUE;
            if (mockAnnotation.min().length() > 0) {
                min = format.parse(mockAnnotation.min()).getTime();
            }
            if (mockAnnotation.max().length() > 0) {
                max = format.parse(mockAnnotation.max()).getTime();
            }
            long l = dateTime = min == max ? min : (long)(Math.random() * (double)(Math.max(max, min) - Math.min(max, min))) + Math.min(max, min);
            if (Date.class.equals((Object)clazz)) {
                return new Date(dateTime);
            }
            if (Calendar.class.equals((Object)clazz)) {
                Calendar calendar = Clock.getCalendar();
                calendar.setTimeInMillis(dateTime);
                return calendar;
            }
            if (String.class.equals((Object)clazz)) {
                return format.format(new Date(dateTime));
            }
            return null;
        }
        catch (Throwable th) {
            throw new RuntimeException(th.getLocalizedMessage(), th);
        }
    }
}

