/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.mock;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.coodex.mock.Mock;
import org.coodex.mock.MockException;
import org.coodex.mock.TypeMocker;
import org.coodex.util.Common;

public abstract class AbstractTypeMocker<A extends Annotation>
implements TypeMocker<A> {
    private Class[] SUPPORTED = null;

    private static Class getClassFromType(Type targetType, boolean throwException) {
        if (targetType instanceof Class) {
            return (Class)targetType;
        }
        if (targetType instanceof ParameterizedType) {
            return AbstractTypeMocker.getClassFromType(((ParameterizedType)targetType).getRawType(), throwException);
        }
        if (throwException) {
            throw new MockException("targetType is not Class: " + targetType);
        }
        return null;
    }

    protected static Class getClassFromType(Type targetType) {
        return AbstractTypeMocker.getClassFromType(targetType, true);
    }

    protected abstract Class[] getSupportedClasses();

    protected abstract boolean accept(A var1);

    public boolean accept(A mockAnnotation, Type targetType) {
        return this.accept(mockAnnotation) && Common.inArray((Object)AbstractTypeMocker.getClassFromType(targetType, false), (Object[])this.getSupported());
    }

    private Class[] getSupported() {
        if (this.SUPPORTED == null) {
            this.SUPPORTED = this.getSupportedClasses();
        }
        return this.SUPPORTED;
    }

    public Object mock(A mockAnnotation, Mock.Nullable nullable, Type targetType) {
        Class c;
        if (nullable != null && ((c = AbstractTypeMocker.getClassFromType(targetType, false)) == null || !c.isPrimitive()) && Math.random() < nullable.probability()) {
            return null;
        }
        return this.mock(mockAnnotation, targetType);
    }

    public abstract Object mock(A var1, Type var2);
}

