/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.mock;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.coodex.mock.AbstractTypeMocker;
import org.coodex.mock.Mock;
import org.coodex.mock.MockException;
import org.coodex.util.Common;
import org.coodex.util.Singleton;

public class NumberTypeMocker
extends AbstractTypeMocker<Mock.Number> {
    private static final char[] IGNORE = " \t\r\n".toCharArray();
    private static final char[] RANGE_START = "[(".toCharArray();
    private static final char[] RANGE_END = ")]".toCharArray();
    private static final char[] DELIMITER = ",".toCharArray();
    private static final char[] LEFT_BRACKETS_INCLUDE = "[".toCharArray();
    private static final char[] RIGHT_BRACKETS_INCLUDE = "]".toCharArray();
    private static final Singleton<NumberTypeMocker> instance = Singleton.with(NumberTypeMocker::new);
    static Class<?>[] SUPPORTED = new Class[]{Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, String.class, BigDecimal.class};

    static Object mock(Class<?> c) {
        return ((NumberTypeMocker)instance.get()).mock(null, null, c);
    }

    private static boolean inArray(char ch, char[] chars) {
        for (char chInArray : chars) {
            if (ch != chInArray) continue;
            return true;
        }
        return false;
    }

    private static List<String> split(String range) {
        String v;
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder builder = null;
        for (char ch : range.toCharArray()) {
            if (NumberTypeMocker.inArray(ch, DELIMITER)) {
                if (builder == null) {
                    throw new MockException("invalid range: " + range);
                }
                String v2 = builder.toString().trim();
                if (!Common.isBlank((String)v2)) {
                    list.add(v2);
                }
                builder = null;
                continue;
            }
            if (NumberTypeMocker.inArray(ch, IGNORE)) {
                if (builder == null) continue;
                builder.append(ch);
                continue;
            }
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(ch);
        }
        if (builder != null && !Common.isBlank((String)(v = builder.toString().trim()))) {
            list.add(v);
        }
        return list;
    }

    private static <T> Range<T> buildRange(String left, String right, Class<T> c) {
        if (!NumberTypeMocker.inArray(left.charAt(0), RANGE_START)) {
            throw new MockException("invalid range: " + left);
        }
        char rightLast = right.charAt(right.length() - 1);
        if (!NumberTypeMocker.inArray(rightLast, RANGE_END)) {
            throw new MockException("invalid range: " + right);
        }
        boolean includeMin = NumberTypeMocker.inArray(left.charAt(0), LEFT_BRACKETS_INCLUDE);
        boolean includeMax = NumberTypeMocker.inArray(rightLast, RIGHT_BRACKETS_INCLUDE);
        String min = left.substring(1);
        String max = right.substring(0, right.length() - 1);
        if (Byte.class.equals(c) || Byte.TYPE.equals(c)) {
            return (Range)Common.cast((Object)new ByteRange(includeMin, min, max, includeMax));
        }
        if (Short.class.equals(c) || Short.TYPE.equals(c)) {
            return (Range)Common.cast((Object)new ShortRange(includeMin, min, max, includeMax));
        }
        if (Integer.class.equals(c) || Integer.TYPE.equals(c)) {
            return (Range)Common.cast((Object)new IntegerRange(includeMin, min, max, includeMax));
        }
        if (Long.class.equals(c) || Long.TYPE.equals(c)) {
            return (Range)Common.cast((Object)new LongRange(includeMin, min, max, includeMax));
        }
        if (Float.class.equals(c) || Float.TYPE.equals(c)) {
            return (Range)Common.cast((Object)new FloatRange(includeMin, min, max, includeMax));
        }
        if (Double.class.equals(c) || Double.TYPE.equals(c)) {
            return (Range)Common.cast((Object)new DoubleRange(includeMin, min, max, includeMax));
        }
        return null;
    }

    private static <T> Alternative<T> getAlternative(String range, Class<T> clz) {
        List<String> list = NumberTypeMocker.split(range);
        Merge<T> merge = new Merge<T>();
        int i = 0;
        int len = list.size();
        while (i < len) {
            String s = list.get(i);
            if (NumberTypeMocker.inArray(s.charAt(0), RANGE_START)) {
                merge.add(NumberTypeMocker.buildRange(s, list.get(i + 1), clz));
                i += 2;
                continue;
            }
            merge.add(NumberTypeMocker.buildSingle(s, clz));
            ++i;
        }
        return merge;
    }

    private static <T> Alternative<T> buildSingle(String s, Class<T> c) {
        if (Byte.class.equals(c) || Byte.TYPE.equals(c)) {
            return (Alternative)Common.cast((Object)new ByteSingle(s));
        }
        if (Short.class.equals(c) || Short.TYPE.equals(c)) {
            return (Alternative)Common.cast((Object)new ShortSingle(s));
        }
        if (Integer.class.equals(c) || Integer.TYPE.equals(c)) {
            return (Alternative)Common.cast((Object)new IntegerSingle(s));
        }
        if (Long.class.equals(c) || Long.TYPE.equals(c)) {
            return (Alternative)Common.cast((Object)new LongSingle(s));
        }
        if (Float.class.equals(c) || Float.TYPE.equals(c)) {
            return (Alternative)Common.cast((Object)new FloatSingle(s));
        }
        if (Double.class.equals(c) || Double.TYPE.equals(c)) {
            return (Alternative)Common.cast((Object)new DoubleSingle(s));
        }
        return null;
    }

    private static long parseNumber(String str, int bits) {
        switch (bits) {
            case 8: {
                return Byte.parseByte(str);
            }
            case 16: {
                return Short.parseShort(str);
            }
            case 32: {
                return Integer.parseInt(str);
            }
        }
        return Long.parseLong(str);
    }

    private static long parseHex(String str, int bits) {
        switch (bits) {
            case 8: {
                return Byte.parseByte(str, 16);
            }
            case 16: {
                return Short.parseShort(str, 16);
            }
            case 32: {
                return Integer.parseInt(str, 16);
            }
        }
        return Long.parseLong(str, 16);
    }

    private static long getMax(int bits) {
        switch (bits) {
            case 8: {
                return 127L;
            }
            case 16: {
                return 32767L;
            }
            case 32: {
                return Integer.MAX_VALUE;
            }
        }
        return Long.MAX_VALUE;
    }

    private static long getMin(int bits) {
        switch (bits) {
            case 8: {
                return -128L;
            }
            case 16: {
                return -32768L;
            }
            case 32: {
                return Integer.MIN_VALUE;
            }
        }
        return Long.MIN_VALUE;
    }

    public static Object mock(Type targetType, String range, int digits) {
        Class<?> c = NumberTypeMocker.getClassFromType(targetType);
        if (BigDecimal.class.equals(c)) {
            BigDecimal bigDecimal = new BigDecimal(NumberTypeMocker.getAlternative(range, Double.class).mock().toString());
            if (digits <= -1) {
                return bigDecimal;
            }
            return bigDecimal.setScale(digits, RoundingMode.HALF_UP);
        }
        if (String.class.equals(c)) {
            BigDecimal bigDecimal = new BigDecimal(NumberTypeMocker.getAlternative(range, Float.class).mock().toString());
            if (digits <= -1) {
                return bigDecimal.toString();
            }
            return bigDecimal.setScale(digits, RoundingMode.HALF_UP).toString();
        }
        int index = Common.indexOf((Object[])SUPPORTED, c);
        return NumberTypeMocker.round(index, NumberTypeMocker.getAlternative(range, SUPPORTED[index]).mock(), digits);
    }

    private static Object round(int i, Object value, int digits) {
        if (digits == -1) {
            return value;
        }
        BigDecimal bigDecimal = new BigDecimal(value.toString()).setScale(digits, RoundingMode.HALF_UP);
        switch (i) {
            case 8: 
            case 9: {
                return Float.valueOf(bigDecimal.floatValue());
            }
            case 10: 
            case 11: {
                return bigDecimal.doubleValue();
            }
        }
        return value;
    }

    @Override
    protected Class<?>[] getSupportedClasses() {
        return SUPPORTED;
    }

    @Override
    protected boolean accept(Mock.Number annotation) {
        return true;
    }

    @Override
    public Object mock(Mock.Number mockAnnotation, Type targetType) {
        String range = mockAnnotation == null || Common.isBlank((String)mockAnnotation.value().trim()) ? "[min, max]" : mockAnnotation.value();
        int digits = mockAnnotation == null ? 2 : mockAnnotation.digits();
        return NumberTypeMocker.mock(targetType, range, digits);
    }

    private static class ByteRange
    extends AbstractIntRange<Byte> {
        ByteRange(boolean includeMin, String min, String max, boolean includeMax) {
            super(includeMin, min, max, includeMax);
        }

        @Override
        int getBits() {
            return 8;
        }

        @Override
        Byte to(long random) {
            return (byte)random;
        }
    }

    private static class ShortRange
    extends AbstractIntRange<Short> {
        ShortRange(boolean includeMin, String min, String max, boolean includeMax) {
            super(includeMin, min, max, includeMax);
        }

        @Override
        int getBits() {
            return 16;
        }

        @Override
        Short to(long random) {
            return (short)random;
        }
    }

    private static class IntegerRange
    extends AbstractIntRange<Integer> {
        IntegerRange(boolean includeMin, String min, String max, boolean includeMax) {
            super(includeMin, min, max, includeMax);
        }

        @Override
        int getBits() {
            return 32;
        }

        @Override
        Integer to(long random) {
            return (int)random;
        }
    }

    private static class LongRange
    extends AbstractIntRange<Long> {
        LongRange(boolean includeMin, String min, String max, boolean includeMax) {
            super(includeMin, min, max, includeMax);
        }

        @Override
        int getBits() {
            return 64;
        }

        @Override
        Long to(long random) {
            return random;
        }
    }

    private static abstract class AbstractIntRange<T extends Number>
    extends Range<T> {
        private long longMin;
        private long longMax;

        AbstractIntRange(boolean includeMin, String min, String max, boolean includeMax) {
            super(includeMin, min, max, includeMax);
            this.longMin = ((Number)this.min).longValue();
            if (!includeMin) {
                ++this.longMin;
            }
            this.longMax = ((Number)this.max).longValue();
            if (!includeMax) {
                --this.longMax;
            }
            this.weight = this.calcWeight();
        }

        abstract int getBits();

        @Override
        T parseMin(String min) {
            String s = min.toLowerCase();
            if (s.equals("min")) {
                return this.to(NumberTypeMocker.getMin(this.getBits()));
            }
            return this.parse(min);
        }

        @Override
        T parseMax(String max) {
            String s = max.toLowerCase();
            if (s.equals("max")) {
                return this.to(NumberTypeMocker.getMax(this.getBits()));
            }
            return this.parse(max);
        }

        private T parse(String value) {
            String temp = value.toLowerCase();
            long l = temp.startsWith("0x") ? NumberTypeMocker.parseHex(temp.substring(2), this.getBits()) : NumberTypeMocker.parseNumber(value, this.getBits());
            if (l > NumberTypeMocker.getMax(this.getBits()) || l < NumberTypeMocker.getMin(this.getBits())) {
                throw new MockException("out of range: " + value);
            }
            return this.to(l);
        }

        @Override
        int calcWeight() {
            long x = this.longMax - this.longMin + 1L;
            if (x <= 0L) {
                if (this.longMin < this.longMax) {
                    return 1000;
                }
                throw new MockException("range error" + (this.includeMin ? (char)'[' : '(') + this.minStr + ", " + this.maxStr + (this.includeMax ? (char)']' : ')'));
            }
            return (int)Math.min(x, 1000L);
        }

        private long check(long random) {
            if (random > this.longMax || random < this.longMin) {
                throw new MockException("out of range: " + random + ". " + (this.includeMin ? (char)'[' : '(') + this.minStr + ", " + this.maxStr + (this.includeMax ? (char)']' : ')'));
            }
            return random;
        }

        @Override
        public T mock() {
            return this.to(this.check(this.random()));
        }

        private long random() {
            if (this.longMin == this.longMax) {
                return this.longMin;
            }
            long x = this.longMax - this.longMin + 1L;
            long random = new Random().nextLong();
            if (x <= 0L) {
                if (random > this.longMax) {
                    return this.longMin + (random - this.longMax);
                }
                if (random < this.longMin) {
                    return this.longMax - (this.longMin - random);
                }
                return random;
            }
            return this.longMin + Math.abs(random) % x;
        }

        abstract T to(long var1);
    }

    private static class FloatRange
    extends Range<Float> {
        FloatRange(boolean includeMin, String min, String max, boolean includeMax) {
            super(includeMin, min, max, includeMax);
            this.weight = this.calcWeight();
        }

        private Float random() {
            float x = ((Float)this.max).floatValue() - ((Float)this.min).floatValue();
            float random = (float)Math.random();
            if (Float.isInfinite(x)) {
                float over = random * Float.MAX_VALUE;
                if (Math.random() < 0.5) {
                    over *= -1.0f;
                }
                if (over > ((Float)this.max).floatValue()) {
                    return Float.valueOf(over - ((Float)this.max).floatValue() + ((Float)this.min).floatValue());
                }
                if (over < ((Float)this.min).floatValue()) {
                    return Float.valueOf(((Float)this.max).floatValue() - (((Float)this.min).floatValue() - over));
                }
                return Float.valueOf(over);
            }
            return Float.valueOf(((Float)this.min).floatValue() + random * x);
        }

        private Float check(Float v) {
            if (v.floatValue() >= ((Float)this.max).floatValue() || v.floatValue() < ((Float)this.min).floatValue()) {
                throw new MockException("mock error: " + v + ". " + this);
            }
            return v;
        }

        @Override
        public Float mock() {
            return this.check(this.random());
        }

        @Override
        Float parseMin(String min) {
            if (min.equalsIgnoreCase("min")) {
                return Float.valueOf(-3.4028235E38f);
            }
            return Float.valueOf(Float.parseFloat(min));
        }

        @Override
        Float parseMax(String max) {
            if (max.equalsIgnoreCase("max")) {
                return Float.valueOf(Float.MAX_VALUE);
            }
            return Float.valueOf(Float.parseFloat(max));
        }

        @Override
        int calcWeight() {
            float x = ((Float)this.max).floatValue() - ((Float)this.min).floatValue();
            if (Float.isInfinite(x)) {
                return 1000;
            }
            if (((Float)this.min).floatValue() + 1000.0f > ((Float)this.max).floatValue()) {
                return Math.max(1, (int)x);
            }
            return 1000;
        }
    }

    private static class DoubleRange
    extends Range<Double> {
        DoubleRange(boolean includeMin, String min, String max, boolean includeMax) {
            super(includeMin, min, max, includeMax);
            this.weight = this.calcWeight();
        }

        @Override
        public Double mock() {
            return this.check(this.random());
        }

        @Override
        Double parseMin(String min) {
            if (min.equalsIgnoreCase("min")) {
                return -1.7976931348623157E308;
            }
            return Double.parseDouble(min);
        }

        @Override
        Double parseMax(String max) {
            if (max.equalsIgnoreCase("max")) {
                return Double.MAX_VALUE;
            }
            return Double.parseDouble(max);
        }

        private Double random() {
            double x = (Double)this.max - (Double)this.min;
            double random = Math.random();
            if (Double.isInfinite(x)) {
                double over = random * Double.MAX_VALUE;
                if (Math.random() < 0.5) {
                    over *= -1.0;
                }
                if (over > (Double)this.max) {
                    return over - (Double)this.max + (Double)this.min;
                }
                if (over < (Double)this.min) {
                    return (Double)this.max - ((Double)this.min - over);
                }
                return over;
            }
            return (Double)this.min + random * x;
        }

        private Double check(Double v) {
            if (v >= (Double)this.max || v < (Double)this.min) {
                throw new MockException("mock error: " + v + ". " + this);
            }
            return v;
        }

        @Override
        int calcWeight() {
            double x = (Double)this.max - (Double)this.min;
            if (Double.isInfinite(x)) {
                return 1000;
            }
            if ((Double)this.min + 1000.0 > (Double)this.max) {
                return Math.max(1, (int)x);
            }
            return 1000;
        }
    }

    private static abstract class Range<T>
    implements Alternative<T> {
        int weight;
        T min;
        String minStr;
        String maxStr;
        boolean includeMin;
        T max;
        boolean includeMax;

        Range(boolean includeMin, String min, String max, boolean includeMax) {
            this.includeMin = includeMin;
            this.includeMax = includeMax;
            this.maxStr = max;
            this.minStr = min;
            this.min = this.parseMin(min);
            this.max = this.parseMax(max);
        }

        abstract T parseMin(String var1);

        abstract T parseMax(String var1);

        abstract int calcWeight();

        @Override
        public int weight() {
            return this.weight;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{weight=" + this.weight + ", def=" + (this.includeMin ? (char)'[' : '(') + this.minStr + ", " + this.maxStr + (this.includeMax ? (char)']' : ')') + ", range=" + (this.includeMin ? (char)'[' : '(') + this.min + ", " + this.max + (this.includeMax ? (char)']' : ')') + '}';
        }
    }

    private static class ByteSingle
    extends AbstractIntSingle<Byte> {
        ByteSingle(String valueStr) {
            super(valueStr);
        }

        @Override
        int getBits() {
            return 8;
        }

        @Override
        Byte to(long l) {
            return (byte)l;
        }
    }

    private static class ShortSingle
    extends AbstractIntSingle<Short> {
        ShortSingle(String valueStr) {
            super(valueStr);
        }

        @Override
        int getBits() {
            return 16;
        }

        @Override
        Short to(long l) {
            return (short)l;
        }
    }

    private static class IntegerSingle
    extends AbstractIntSingle<Integer> {
        IntegerSingle(String valueStr) {
            super(valueStr);
        }

        @Override
        int getBits() {
            return 32;
        }

        @Override
        Integer to(long l) {
            return (int)l;
        }
    }

    private static class LongSingle
    extends AbstractIntSingle<Long> {
        LongSingle(String valueStr) {
            super(valueStr);
        }

        @Override
        int getBits() {
            return 64;
        }

        @Override
        Long to(long l) {
            return l;
        }
    }

    private static class FloatSingle
    extends Single<Float> {
        FloatSingle(String valueStr) {
            super(valueStr);
        }

        @Override
        Float parseValue(String valueStr) {
            if ("min".equalsIgnoreCase(valueStr)) {
                return Float.valueOf(-3.4028235E38f);
            }
            if ("max".equalsIgnoreCase(valueStr)) {
                return Float.valueOf(Float.MAX_VALUE);
            }
            return Float.valueOf(Float.parseFloat(valueStr));
        }
    }

    private static class DoubleSingle
    extends Single<Double> {
        DoubleSingle(String valueStr) {
            super(valueStr);
        }

        @Override
        Double parseValue(String valueStr) {
            if ("min".equalsIgnoreCase(valueStr)) {
                return -1.7976931348623157E308;
            }
            if ("max".equalsIgnoreCase(valueStr)) {
                return Double.MAX_VALUE;
            }
            return Double.parseDouble(valueStr);
        }
    }

    private static abstract class AbstractIntSingle<T extends Number>
    extends Single<T> {
        AbstractIntSingle(String valueStr) {
            super(valueStr);
        }

        abstract int getBits();

        abstract T to(long var1);

        @Override
        T parseValue(String valueStr) {
            if ("min".equalsIgnoreCase(valueStr)) {
                return this.to(NumberTypeMocker.getMin(this.getBits()));
            }
            if ("max".equalsIgnoreCase(valueStr)) {
                return this.to(NumberTypeMocker.getMax(this.getBits()));
            }
            if (valueStr.toLowerCase().startsWith("0x")) {
                return this.to(NumberTypeMocker.parseHex(valueStr.substring(2), this.getBits()));
            }
            return this.to(NumberTypeMocker.parseNumber(valueStr, this.getBits()));
        }
    }

    private static abstract class Single<T>
    implements Alternative<T> {
        private final T value;
        private final String numberStr;

        Single(String valueStr) {
            this.numberStr = valueStr;
            this.value = this.parseValue(valueStr);
        }

        abstract T parseValue(String var1);

        @Override
        public int weight() {
            return 1;
        }

        @Override
        public T mock() {
            return this.value;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{value=" + this.value + ", numberStr='" + this.numberStr + '\'' + '}';
        }
    }

    private static class Merge<T>
    implements Alternative<T> {
        private final List<Alternative<T>> alternatives = new ArrayList<Alternative<T>>();
        private int weight = 0;

        private Merge() {
        }

        void add(Alternative<T> alternative) {
            this.alternatives.add(alternative);
            this.weight += alternative.weight();
        }

        @Override
        public int weight() {
            return this.weight;
        }

        @Override
        public T mock() {
            int random = this.weight > 1 ? new Random().nextInt(this.weight) : 0;
            for (Alternative<T> alternative : this.alternatives) {
                if ((random -= alternative.weight()) >= 0) continue;
                return alternative.mock();
            }
            throw new MockException("weight error: " + random);
        }

        public String toString() {
            return "Merge{alternatives=" + this.alternatives + ", weight=" + this.weight + '}';
        }
    }

    private static interface Alternative<T> {
        public int weight();

        public T mock();
    }
}

