/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.mock;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.coodex.mock.AbstractTypeMocker;
import org.coodex.mock.CharTypeMocker;
import org.coodex.mock.EmojiMocker;
import org.coodex.mock.Mock;
import org.coodex.util.Common;
import org.coodex.util.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringTypeMocker
extends AbstractTypeMocker<Mock.String> {
    private static final Logger log = LoggerFactory.getLogger(StringTypeMocker.class);
    private static final Class<?>[] SUPPORTED_CLASSES = new Class[]{String.class};
    private static final Singleton<StringTypeMocker> instance = Singleton.with(StringTypeMocker::new);

    static String mock() {
        return (String)((StringTypeMocker)instance.get()).mock(null, null, (Type)((Object)String.class));
    }

    @Override
    protected Class<?>[] getSupportedClasses() {
        return SUPPORTED_CLASSES;
    }

    @Override
    protected boolean accept(Mock.String annotation) {
        return true;
    }

    public String mock(Mock.String mockAnnotation, Type targetType) {
        return this.getStringRange(mockAnnotation).random();
    }

    private StringRange getStringRange(Mock.String stringAnnotation) {
        StringRange range = null;
        if (stringAnnotation != null) {
            range = this.loadFromResource(stringAnnotation);
            if (range == null && stringAnnotation.range().length > 0) {
                range = new ArrayStringRange(Arrays.asList(stringAnnotation.range()));
            }
            if (range == null && stringAnnotation.charCodeSets().length > 0) {
                range = new CharRangeBasedStringRange(stringAnnotation.minLength(), stringAnnotation.maxLength(), stringAnnotation.emojiProbability(), new CharTypeMocker.CodePointSetCharRange(stringAnnotation.charCodeSets(), false));
            }
        }
        if (range == null) {
            range = new CharRangeBasedStringRange(stringAnnotation == null ? 5 : stringAnnotation.minLength(), stringAnnotation == null ? 10 : stringAnnotation.maxLength(), stringAnnotation == null ? 0.0f : stringAnnotation.emojiProbability(), new CharTypeMocker.ArrayCharRange(CharTypeMocker.getRange("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ", false)));
        }
        return range;
    }

    private StringRange loadFromResource(Mock.String stringAnnotation) {
        URL url;
        if (!Common.isBlank((String)stringAnnotation.txtResource()) && (url = Common.getResource((String)stringAnnotation.txtResource(), (ClassLoader[])new ClassLoader[0])) != null) {
            ArrayList<String> stringList = new ArrayList<String>();
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    stringList.add(line);
                }
            }
            catch (Throwable throwable) {
                log.warn("load resource [{}] error: {}", new Object[]{stringAnnotation, throwable.getLocalizedMessage(), throwable});
            }
            if (stringList.size() > 0) {
                return new ArrayStringRange(stringList);
            }
        }
        return null;
    }

    private static class ArrayStringRange
    implements StringRange {
        private final List<String> list;

        ArrayStringRange(List<String> strings) {
            this.list = new ArrayList<String>(strings);
        }

        @Override
        public String random() {
            Random random = new Random();
            return this.list.get(random.nextInt(this.list.size()));
        }
    }

    private static class CharRangeBasedStringRange
    implements StringRange {
        final int min;
        final int max;
        final float emojiProbability;
        final CharTypeMocker.CharRange charRange;

        private CharRangeBasedStringRange(int min, int max, float emojiProbability, CharTypeMocker.CharRange charRange) {
            this.min = Math.max(1, Math.min(min, max));
            this.max = Math.max(1, Math.max(min, max));
            this.emojiProbability = emojiProbability;
            this.charRange = charRange;
        }

        @Override
        public String random() {
            StringBuilder builder = new StringBuilder();
            int len = new Random().nextInt(this.max - this.min + 1) + this.min;
            for (int i = 0; i <= len; ++i) {
                if (this.emojiProbability > 0.0f && Math.random() < (double)this.emojiProbability) {
                    builder.append(EmojiMocker.mock());
                    continue;
                }
                builder.append(Character.toChars(this.charRange.random()));
            }
            return builder.toString();
        }
    }

    static interface StringRange {
        public String random();
    }
}

