/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.mock.ext;

import java.lang.reflect.Type;
import org.coodex.mock.AbstractTypeMocker;
import org.coodex.mock.ext.VehicleNum;
import org.coodex.util.Common;

public class VehicleNumTypeMocker
extends AbstractTypeMocker<VehicleNum> {
    @Override
    protected Class<?>[] getSupportedClasses() {
        return new Class[]{String.class};
    }

    @Override
    protected boolean accept(VehicleNum annotation) {
        return annotation != null;
    }

    @Override
    public Object mock(VehicleNum mockAnnotation, Type targetType) {
        if (mockAnnotation.belong().length == 0) {
            return null;
        }
        VehicleNum.Province province = mockAnnotation.belong()[Common.random((int)(mockAnnotation.belong().length - 1))];
        StringBuilder builder = new StringBuilder();
        builder.append(province.getX());
        String codeRange = new String(province.getCode());
        if (mockAnnotation.governmentVehicle()) {
            codeRange = codeRange + 'O';
        }
        builder.append(Common.randomChar((String)codeRange));
        int alphabetCount = 0;
        String alphabets = "ABCDEFGHJKLMNPQRSTUVWXYZ";
        String numbers = "0123456789";
        for (int i = 1; i < 5; ++i) {
            if (alphabetCount < 2 && Math.random() < 0.1) {
                builder.append(Common.randomChar((String)alphabets));
                ++alphabetCount;
                continue;
            }
            builder.append(Common.randomChar((String)numbers));
        }
        String lastRange = numbers + alphabets;
        if (mockAnnotation.coachVehicle()) {
            lastRange = lastRange + '\u5b66';
        }
        if (mockAnnotation.towedVehicle()) {
            lastRange = lastRange + '\u6302';
        }
        builder.append(Common.randomChar((String)lastRange));
        return builder.toString();
    }
}

