/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.mock.ext;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import org.coodex.mock.AbstractTypeMocker;
import org.coodex.mock.ext.IpAddress;
import org.coodex.util.Common;
import org.coodex.util.GenericTypeHelper;

public class IpAddressTypeMocker
extends AbstractTypeMocker<IpAddress> {
    @Override
    protected Class<?>[] getSupportedClasses() {
        return new Class[]{String.class, int[].class, Integer[].class, byte[].class, Byte[].class};
    }

    @Override
    protected boolean accept(IpAddress annotation) {
        return annotation != null;
    }

    private Object to(Class<?> c, int[] ip) {
        switch (Common.indexOf((Object[])this.getSupportedClasses(), c)) {
            case 1: {
                return ip;
            }
            case 2: {
                return this.toArray(ip, Integer.class, false);
            }
            case 3: {
                return this.toArray(ip, Byte.TYPE, true);
            }
            case 4: {
                return this.toArray(ip, Byte.class, true);
            }
        }
        return null;
    }

    private Object toArray(int[] ip, Class<?> c, boolean toByte) {
        Object result = Array.newInstance(c, ip.length);
        for (int i = 0; i < ip.length; ++i) {
            byte b = (byte)ip[i];
            if (toByte) {
                Array.set(result, i, b);
                continue;
            }
            Array.set(result, i, ip[i]);
        }
        return result;
    }

    @Override
    public Object mock(IpAddress mockAnnotation, Type targetType) {
        Class clazz = GenericTypeHelper.typeToClass((Type)targetType);
        int size = mockAnnotation.type().getSize();
        int[] ip = new int[size];
        for (int i = 0; i < size; ++i) {
            ip[i] = Common.RANDOM.nextInt(256);
        }
        if (String.class.equals((Object)targetType)) {
            return mockAnnotation.type().ipToString(ip);
        }
        return this.to(clazz, ip);
    }
}

