/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.mock;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.coodex.id.IDGenerator;
import org.coodex.mock.AbstractTypeMocker;
import org.coodex.mock.Mock;
import org.coodex.util.SingletonMap;

public class IdMockerProvider
extends AbstractTypeMocker<Mock.ID> {
    private static final Class<?>[] SUPPORTED_CLASSES = new Class[]{String.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class};
    private static final SingletonMap<String, AtomicLong> ID_SEQ_MAP = SingletonMap.builder().function(key -> new AtomicLong(0L)).build();

    @Override
    protected Class<?>[] getSupportedClasses() {
        return SUPPORTED_CLASSES;
    }

    @Override
    protected boolean accept(Mock.ID annotation) {
        return true;
    }

    @Override
    public Object mock(Mock.ID mockAnnotation, Type targetType) {
        if (Objects.equals(targetType, String.class)) {
            return IDGenerator.newId();
        }
        if (Objects.equals(targetType, Integer.TYPE) || Objects.equals(targetType, Integer.class)) {
            return (int)((AtomicLong)ID_SEQ_MAP.get((Object)mockAnnotation.group())).incrementAndGet();
        }
        return ((AtomicLong)ID_SEQ_MAP.get((Object)mockAnnotation.group())).incrementAndGet();
    }
}

