/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.mock.ext;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import org.coodex.mock.AbstractTypeMocker;
import org.coodex.mock.NumberTypeMocker;
import org.coodex.mock.ext.Coordinates;
import org.coodex.util.GenericTypeHelper;

public class CoordinatesTypeMocker
extends AbstractTypeMocker<Coordinates> {
    @Override
    protected Class<?>[] getSupportedClasses() {
        return new Class[]{float[].class, Float[].class, double[].class, Double[].class, Float.TYPE, Float.class, Double.class, Double.TYPE, Coordinates.Value.class};
    }

    @Override
    protected boolean accept(Coordinates annotation) {
        return annotation != null;
    }

    @Override
    public Object mock(Coordinates mockAnnotation, Type targetType) {
        Class c = GenericTypeHelper.typeToClass((Type)targetType);
        if (c.isArray()) {
            Object result = Array.newInstance(c.getComponentType(), 2);
            Array.set(result, 0, NumberTypeMocker.mock(c.getComponentType(), mockAnnotation.longitude(), mockAnnotation.digits()));
            Array.set(result, 1, NumberTypeMocker.mock(c.getComponentType(), mockAnnotation.latitude(), mockAnnotation.digits()));
            return result;
        }
        if (Coordinates.Value.class.equals((Object)targetType)) {
            Coordinates.Value value = new Coordinates.Value();
            value.setLongitude(((Double)NumberTypeMocker.mock(Double.class, mockAnnotation.longitude(), mockAnnotation.digits())).doubleValue());
            value.setLatitude(((Double)NumberTypeMocker.mock(Double.class, mockAnnotation.latitude(), mockAnnotation.digits())).doubleValue());
            return value;
        }
        return NumberTypeMocker.mock(targetType, mockAnnotation.dimension().equals((Object)Coordinates.Dimension.LONGITUDE) ? mockAnnotation.longitude() : mockAnnotation.latitude(), mockAnnotation.digits());
    }
}

