/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.mock;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.coodex.mock.AbstractTypeMocker;
import org.coodex.mock.CharCodeSet;
import org.coodex.mock.Mock;
import org.coodex.mock.MockException;
import org.coodex.util.Common;
import org.coodex.util.Singleton;

public class CharTypeMocker
extends AbstractTypeMocker<Mock.Char> {
    static final Class<?>[] SUPPORTED_CLASSES = new Class[]{Character.TYPE, Character.class, String.class};
    private static final Singleton<CharTypeMocker> instance = Singleton.with(CharTypeMocker::new);

    static Object mock(Class<?> c) {
        return ((CharTypeMocker)instance.get()).mock((Mock.Char)null, (Type)c);
    }

    static int[] getRange(String strRange, boolean bmp) {
        int codePoint;
        int[] buf = new int[strRange.length()];
        int charCount = 0;
        int l = buf.length;
        for (int i = 0; i < l; i += Character.charCount(codePoint)) {
            codePoint = strRange.codePointAt(i);
            if (codePoint >>> 16 != 0 && bmp) continue;
            buf[charCount++] = codePoint;
        }
        if (charCount == 0) {
            throw new MockException("none valid char: " + strRange);
        }
        int[] result = new int[charCount];
        System.arraycopy(buf, 0, result, 0, charCount);
        return result;
    }

    @Override
    protected Class<?>[] getSupportedClasses() {
        return SUPPORTED_CLASSES;
    }

    @Override
    protected boolean accept(Mock.Char annotation) {
        return true;
    }

    @Override
    public Object mock(Mock.Char mockAnnotation, Type targetType) {
        CharRange charRange = mockAnnotation == null || mockAnnotation.value().length == 0 ? new ArrayCharRange(CharTypeMocker.getRange(mockAnnotation != null && !Common.isBlank((String)mockAnnotation.range()) ? mockAnnotation.range() : "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ", !String.class.equals((Object)targetType))) : new CodePointSetCharRange(mockAnnotation.value(), !String.class.equals((Object)targetType));
        return this.to(charRange.random(), targetType);
    }

    private Object to(int codePoint, Type type) {
        if (String.class.equals((Object)type)) {
            return new String(Character.toChars(codePoint));
        }
        return Character.valueOf((char)codePoint);
    }

    static class ArrayCharRange
    implements CharRange {
        private final int[] range;

        ArrayCharRange(int[] range) {
            if (range == null || range.length == 0) {
                throw new MockException("char range error.");
            }
            this.range = range;
        }

        @Override
        public int random() {
            return this.range[Common.RANDOM.nextInt(this.range.length)];
        }
    }

    static class CodePointSetCharRange
    implements CharRange {
        private final List<CharCodeSet> list = new ArrayList<CharCodeSet>();

        CodePointSetCharRange(CharCodeSet[] sets, boolean bmp) {
            for (CharCodeSet set : sets) {
                if (bmp && !set.isBmp()) continue;
                this.list.add(set);
            }
            if (this.list.size() == 0) {
                throw new MockException("none valid CharCodeSet.");
            }
        }

        @Override
        public int random() {
            return this.randomChar(Common.RANDOM);
        }

        private int randomChar(Random random) {
            CharCodeSet charCodeSet = this.list.get(random.nextInt(this.list.size()));
            return charCodeSet.getMin() + random.nextInt(charCodeSet.getCount());
        }
    }

    static interface CharRange {
        public int random();
    }
}

