/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.mock;

import java.lang.reflect.Type;
import org.coodex.functional.Supplier;
import org.coodex.mock.AbstractTypeMocker;
import org.coodex.mock.Mock;
import org.coodex.mock.MockException;
import org.coodex.util.Common;
import org.coodex.util.Singleton;

public class BooleanTypeMocker
extends AbstractTypeMocker<Mock.Boolean> {
    static final Class<?>[] SUPPORTED = new Class[]{Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Character.TYPE, Character.class, String.class};
    private static final Singleton<BooleanTypeMocker> instance = Singleton.with((Supplier)new Supplier<BooleanTypeMocker>(){

        public BooleanTypeMocker get() {
            return new BooleanTypeMocker();
        }
    });

    static Object mock(Class<?> c) {
        return ((BooleanTypeMocker)instance.get()).mock(null, null, c);
    }

    @Override
    protected boolean accept(Mock.Boolean annotation) {
        return true;
    }

    @Override
    protected Class<?>[] getSupportedClasses() {
        return SUPPORTED;
    }

    @Override
    public Object mock(Mock.Boolean mockAnnotation, Type targetType) {
        double probabilityOfTrue = mockAnnotation == null ? 0.5 : mockAnnotation.probabilityOfTrue();
        return this.toType(Math.random() < probabilityOfTrue, new BooleanMockConfig(mockAnnotation), targetType);
    }

    private Object toType(boolean b, BooleanMockConfig config, Type targetType) {
        Class<?> c = BooleanTypeMocker.getClassFromType(targetType);
        int index = Common.indexOf((Object[])SUPPORTED, c);
        switch (index) {
            case 0: 
            case 1: {
                return b;
            }
            case 2: 
            case 3: {
                return (byte)(b ? config.intTrue : config.intFalse);
            }
            case 4: 
            case 5: {
                return (short)(b ? config.intTrue : config.intFalse);
            }
            case 6: 
            case 7: {
                return b ? config.intTrue : config.intFalse;
            }
            case 8: 
            case 9: {
                return (long)(b ? config.intTrue : config.intFalse) & 0xFFFFFFFFL;
            }
            case 10: 
            case 11: {
                return Character.valueOf(b ? config.charTrue : config.charFalse);
            }
            case 12: {
                return b ? config.strTrue : config.strFalse;
            }
        }
        throw new MockException("Illegal type: " + targetType);
    }

    private static class BooleanMockConfig {
        double probabilityOfTrue = 0.5;
        int intTrue = 1;
        int intFalse = 0;
        char charTrue = (char)84;
        char charFalse = (char)70;
        String strTrue = "true";
        String strFalse = "false";

        BooleanMockConfig(Mock.Boolean annotation) {
            if (annotation != null) {
                this.probabilityOfTrue = annotation.probabilityOfTrue();
                this.intTrue = annotation.intTrue();
                this.intFalse = annotation.intFalse();
                this.charTrue = annotation.charTrue();
                this.charFalse = annotation.charFalse();
                this.strTrue = annotation.strTrue();
                this.strFalse = annotation.strFalse();
            }
        }
    }
}

